/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import org.cip4.lib.xjdf.schema.DeliveryParams;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.validator.DeliveryParamsValidator;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.Validator;

public class ResourceSetValidator
implements Validator<ResourceSet> {
    private final Validator<DeliveryParams> deliveryParamsValidator;

    public ResourceSetValidator() {
        this(new DeliveryParamsValidator());
    }

    public ResourceSetValidator(Validator<DeliveryParams> deliveryParamsValidator) {
        this.deliveryParamsValidator = deliveryParamsValidator;
    }

    @Override
    public final ValidationResult validate(ResourceSet resourceSet) {
        ValidationResult result = new ValidationResult(new String[0]);
        if (null == resourceSet.getName()) {
            result.append("Attribute //ResourceSet/@Name may not be null.");
        } else if ("".equals(resourceSet.getName())) {
            result.append("Attribute //ResourceSet/@Name may not be empty.");
        } else {
            String resourceSetName = resourceSet.getName();
            for (Resource resource : resourceSet.getResource()) {
                String resourceName = resource.getSpecificResource().getName().getLocalPart();
                if (resourceName.equals(resourceSetName)) continue;
                result.append(String.format("ResourceSet with @Name='%s' may only contain Resources of type '%s', but '%s' was found.", resourceSetName, resourceSetName, resourceName));
            }
            switch (resourceSetName) {
                case "DeliveryParams": {
                    for (Resource resource : resourceSet.getResource()) {
                        result.append(this.deliveryParamsValidator.validate((DeliveryParams)resource.getSpecificResource().getValue()));
                    }
                    break;
                }
            }
        }
        return result;
    }
}

