/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.comparator.ResourceSetComparator;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.Resources;

public class XJdfBuilder
extends AbstractNodeBuilder<XJDF> {
    private final XJdfNodeFactory xJdfNodeFactory;
    private final Resources resourceSets = new Resources(((XJDF)this.getNode()).getResourceSet());

    public XJdfBuilder() {
        this(null, null, null, null);
    }

    public XJdfBuilder(String jobID) {
        this(jobID, null, null, null);
    }

    public XJdfBuilder(String jobID, String category) {
        this(jobID, category, null, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName) {
        this(jobID, category, descriptiveName, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName, String relatedJobID) {
        super(new XJdfNodeFactory().createXJDF());
        this.xJdfNodeFactory = new XJdfNodeFactory();
        this.getXJdf().setJobID(jobID);
        this.getXJdf().setCategory(category);
        this.getXJdf().setDescriptiveName(descriptiveName);
        this.getXJdf().setRelatedJobID(relatedJobID);
    }

    public XJdfBuilder(XJDF xjdf) {
        super(xjdf);
        this.xJdfNodeFactory = new XJdfNodeFactory();
        Collections.sort(((XJDF)this.getNode()).getResourceSet(), new ResourceSetComparator());
    }

    public XJDF getXJdf() {
        return (XJDF)this.getNode();
    }

    public final void addComment(String comment) {
        Comment obj = this.xJdfNodeFactory.createComment(comment);
        ((XJDF)this.getNode()).getComment().add(obj);
    }

    public final void addGeneralID(GeneralID generalId) {
        if (generalId == null) {
            return;
        }
        this.getXJdf().getGeneralID().add(generalId);
    }

    public final void addProduct(Product product) {
        if (product == null) {
            return;
        }
        if (this.getXJdf().getProductList() == null) {
            this.getXJdf().setProductList(this.xJdfNodeFactory.createProductList());
        }
        this.getXJdf().getProductList().getProduct().add(product);
    }

    public final void addResource(SpecificResource specificResource) {
        this.addResource(specificResource, null, null);
    }

    public final void addResource(SpecificResource specificResource, String processUsage) {
        this.addResource(specificResource, null, processUsage);
    }

    public final void addResource(List<SpecificResource> specificResources) {
        this.addResource(specificResources, null);
    }

    public final void addResource(List<SpecificResource> specificResources, String processUsage) {
        for (SpecificResource specificResource : specificResources) {
            this.addResource(specificResource, null, processUsage);
        }
    }

    public final Resource addResource(SpecificResource specificResource, Part part) {
        return this.addResource(specificResource, part, null);
    }

    public final Resource addResource(SpecificResource specificResource, Part part, String processUsage) {
        if (specificResource == null) {
            throw new IllegalArgumentException("Resource may not be null.");
        }
        Resource resource = this.xJdfNodeFactory.createResource(specificResource, part);
        resource.setID(resource.getSpecificResource().getName().getLocalPart() + "_" + UUID.randomUUID().toString());
        this.addResource(resource, processUsage);
        return resource;
    }

    public void addResource(Resource resource, String processUsage) {
        this.resourceSets.addResource(resource, processUsage);
    }

    public final void addResourceSet(ResourceSet resourceSet) {
        this.resourceSets.addResourceSet(resourceSet);
    }
}

