/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.comparator.ResourceSetComparator;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Resources {
    private final List<ResourceSet> resourceSets;
    private final ResourceSetComparator resourceSetComparator = new ResourceSetComparator();
    private final XJdfNodeFactory nodeFactory = new XJdfNodeFactory();

    public Resources() {
        this(new ArrayList<ResourceSet>());
    }

    public Resources(@NotNull List<ResourceSet> resourceSets) {
        this.resourceSets = resourceSets;
    }

    public final void addResource(@NotNull Resource resource, @Nullable String processUsage) {
        String resourceName = this.getResourceName(resource);
        ResourceSet resourceSet = this.findResourceSet(resourceName, processUsage);
        if (null == resourceSet) {
            resourceSet = new ResourceSet();
            resourceSet.withName(resourceName).withProcessUsage(processUsage);
            this.addResourceSet(resourceSet);
        }
        resourceSet.getResource().add(resource);
    }

    public final void addResource(@NotNull SpecificResource specificResource, @Nullable Part part, @Nullable String processUsage) {
        this.addResource(this.createResource(specificResource, part), processUsage);
    }

    @Nullable
    final ResourceSet findResourceSet(@NotNull String resourceName, @Nullable String processUsage) {
        for (ResourceSet resourceSet : this.resourceSets) {
            if (!resourceSet.getName().equals(resourceName) || (processUsage != null || resourceSet.getProcessUsage() != null) && (processUsage == null || !processUsage.equals(resourceSet.getProcessUsage()))) continue;
            return resourceSet;
        }
        return null;
    }

    public <T extends SpecificResource> List<T> findSpecificResource(Class<T> findClass, Part part, String processUsage) {
        ResourceSet resourceSet = this.findResourceSet(findClass.getSimpleName(), processUsage);
        ArrayList<SpecificResource> foundParameters = new ArrayList<SpecificResource>();
        if (resourceSet == null) {
            return foundParameters;
        }
        for (Resource resource : resourceSet.getResource()) {
            SpecificResource parameterType;
            if (!this.isAnyPartMatch(part, resource.getPart()) || !findClass.isInstance(parameterType = (SpecificResource)resource.getSpecificResource().getValue())) continue;
            foundParameters.add((SpecificResource)resource.getSpecificResource().getValue());
        }
        return foundParameters;
    }

    public final void addResourceSet(ResourceSet resourceSet) {
        ListIterator<ResourceSet> listIterator = this.resourceSets.listIterator();
        while (listIterator.hasNext()) {
            ResourceSet currentSet = listIterator.next();
            if (this.resourceSetComparator.compare(currentSet, resourceSet) <= 0) continue;
            if (!listIterator.hasPrevious()) break;
            listIterator.previous();
            break;
        }
        listIterator.add(resourceSet);
    }

    @NotNull
    <V extends SpecificResource> Resource createResource(@NotNull V resourceType, @Nullable Part partition) {
        Resource resource = this.getNodeFactory().createResource(resourceType, partition);
        if (null == resource.getID()) {
            resource.setID(resource.getSpecificResource().getName().getLocalPart() + "_" + UUID.randomUUID());
        }
        return resource;
    }

    @NotNull
    final String getResourceName(@NotNull Resource resource) {
        return resource.getSpecificResource().getName().getLocalPart();
    }

    @NotNull
    private XJdfNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public List<ResourceSet> getResourceSets() {
        return this.resourceSets;
    }

    private boolean isAnyPartMatch(Part searchingPart, List<Part> parts) {
        for (Part part : parts) {
            if (!this.isPartsMatching(searchingPart, part)) continue;
            return true;
        }
        return false;
    }

    boolean isPartsMatching(Part searchingPart, Part part) {
        for (Field partField : Part.class.getDeclaredFields()) {
            try {
                partField.setAccessible(true);
                if (partField.get(searchingPart) == null || partField.get(part) == null || partField.get(part).equals(partField.get(searchingPart))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("I hope, that this can't happen.");
            }
        }
        return true;
    }
}

