/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlIDREF;

public class ClassInspector {
    private Class aClass;

    public ClassInspector(Class aClass) {
        this.aClass = aClass;
    }

    public Collection<Method> getGetters() {
        LinkedList<Method> getters = new LinkedList<Method>();
        this.readGetters(getters, this.aClass);
        return getters;
    }

    private void readGetters(Collection<Method> getters, Class c) {
        if (c.equals(Object.class) || c.equals(Enum.class)) {
            return;
        }
        for (Method method : c.getDeclaredMethods()) {
            if (!this.isGetter(method)) continue;
            getters.add(method);
        }
        this.readGetters(getters, c.getSuperclass());
    }

    public boolean isGetter(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    public boolean isReference(Method method) {
        try {
            return this.isReference(this.getFieldByGetter(method));
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public boolean isReference(Field field) {
        return field.isAnnotationPresent(XmlIDREF.class);
    }

    public Field getFieldByGetter(Method getter) throws NoSuchFieldException {
        String propertyName = getter.getName().substring(3);
        propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
        return this.aClass.getDeclaredField(propertyName);
    }
}

