/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class Duration
extends AbstractXJdfType<String, Duration> {
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;

    public Duration() {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
    }

    public Duration(int day) {
        this(0, 0, day, 0, 0, 0);
    }

    public Duration(int day, int hour) {
        this(0, 0, day, hour, 0, 0);
    }

    public Duration(String expression) {
        if (expression == null) {
            this.year = 0;
            this.month = 0;
            this.day = 0;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            return;
        }
        String expr = expression;
        int posDaytime = expr.indexOf("T");
        if (posDaytime != -1) {
            String daytime = expr.substring(posDaytime + 1);
            expr = expr.substring(0, posDaytime);
            int posHour = daytime.indexOf("H");
            this.hour = posHour != -1 ? Integer.parseInt(daytime.substring(0, posHour)) : 0;
            daytime = daytime.substring(posHour + 1);
            int posMinute = daytime.indexOf("M");
            this.minute = posMinute != -1 ? Integer.parseInt(daytime.substring(0, posMinute)) : 0;
            int posSecond = (daytime = daytime.substring(posMinute + 1)).indexOf("S");
            this.second = posSecond != -1 ? Integer.parseInt(daytime.substring(0, posSecond)) : 0;
        } else {
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
        }
        int posDate = expression.indexOf("P");
        if (posDate != -1) {
            String date = expr.substring(posDate + 1);
            int posYear = date.indexOf("Y");
            this.year = posYear != -1 ? Integer.parseInt(date.substring(0, posYear)) : 0;
            date = date.substring(posYear + 1);
            int posMonth = date.indexOf("M");
            this.month = posMonth != -1 ? Integer.parseInt(date.substring(0, posMonth)) : 0;
            int posDay = (date = date.substring(posMonth + 1)).indexOf("D");
            this.day = posDay != -1 ? Integer.parseInt(date.substring(0, posDay)) : 0;
        } else {
            this.year = 0;
            this.month = 0;
            this.day = 0;
        }
    }

    public Duration(int year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public Duration unmarshal(String v) {
        return new Duration(v);
    }

    public String marshal(Duration duration) {
        if (duration == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(25);
        if (duration.year != 0 || duration.month != 0 || duration.day != 0) {
            b.append("P");
            if (duration.year > 0) {
                b.append(duration.year);
                b.append("Y");
            }
            if (duration.month > 0) {
                b.append(duration.month);
                b.append("M");
            }
            if (duration.day > 0) {
                b.append(duration.day);
                b.append("D");
            }
        }
        if (duration.hour != 0 || duration.minute != 0 || duration.second != 0) {
            b.append("T");
            if (duration.hour > 0) {
                b.append(duration.hour);
                b.append("H");
            }
            if (duration.minute > 0) {
                b.append(duration.minute);
                b.append("M");
            }
            if (duration.second > 0) {
                b.append(duration.second);
                b.append("S");
            }
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

