/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlValidator;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractXmlParser<T> {
    private final JAXBContext jaxbContext;
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    protected AbstractXmlParser(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    protected final Object parseNode(Node w3cNode) throws JAXBException {
        Unmarshaller u = this.jaxbContext.createUnmarshaller();
        return u.unmarshal(w3cNode);
    }

    protected final void parseNode(Object xmlNode, Node w3cNode) throws JAXBException {
        Marshaller m = this.createMarshaller();
        m.marshal(xmlNode, w3cNode);
    }

    protected final byte[] parseXml(T obj) throws ParserConfigurationException, JAXBException, SAXException, IOException {
        return this.parseXml(obj, false);
    }

    protected final void parseXml(T obj, OutputStream os) throws IOException, ParserConfigurationException, SAXException, JAXBException {
        this.parseXml(obj, os, false);
    }

    protected final byte[] parseXml(T obj, boolean skipValidation) throws IOException, ParserConfigurationException, SAXException, JAXBException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.parseXml(obj, bos, skipValidation);
        bos.close();
        return bos.toByteArray();
    }

    protected final void parseXml(T obj, OutputStream os, boolean skipValidation) throws JAXBException, IOException, ParserConfigurationException, SAXException {
        if (!skipValidation) {
            AbstractXmlValidator validator = this.createValidator();
            JAXBSource xmlSource = new JAXBSource(this.jaxbContext, obj);
            validator.validate((Source)xmlSource);
        }
        Marshaller m = this.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)CHARSET.name());
        m.setProperty("com.sun.xml.bind.xmlHeaders", (Object)this.getXmlHeader());
        OutputStreamWriter writer = new OutputStreamWriter(os, CHARSET);
        m.marshal(obj, (Writer)writer);
    }

    public final T parseStream(InputStream is) throws JAXBException {
        Unmarshaller u = this.jaxbContext.createUnmarshaller();
        return (T)u.unmarshal(is);
    }

    protected abstract NamespacePrefixMapper getNamespacePrefixMapper();

    protected abstract String getXmlHeader();

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller m = this.jaxbContext.createMarshaller();
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)this.getNamespacePrefixMapper());
        return m;
    }

    protected abstract AbstractXmlValidator createValidator();
}

