/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator.element;

import java.util.HashSet;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.SimpleValidator;

public class ProductValidator
extends SimpleValidator<Product> {
    @Override
    public void validate(Product product, Ancestors ancestors, ValidationResultBuilder validationResult) {
        HashSet<String> discoveredIntentNames = new HashSet<String>();
        for (Intent intent : product.getIntent()) {
            if (discoveredIntentNames.contains(intent.getName())) {
                validationResult.append(String.format("Product elements SHALL contain at most one intent element with the same Intent/@Name. Multiple Intents with Name '%s' are present.", intent.getName()));
            }
            discoveredIntentNames.add(intent.getName());
        }
    }

    @Override
    public boolean canValidate(Object o) {
        return o instanceof Product;
    }
}

