/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator.element;

import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.SimpleValidator;

public class ResourceSetUsageValidator
extends SimpleValidator<ResourceSet> {
    @Override
    public void validate(ResourceSet resourceSet, Ancestors ancestors, ValidationResultBuilder validationResult) {
        if (null != resourceSet.getUsage()) {
            return;
        }
        if (null != resourceSet.getID()) {
            return;
        }
        for (Resource resource : resourceSet.getResource()) {
            if (null != resource.getID()) continue;
            validationResult.append(String.format("If no @Usage is specified, the ResourceSet or its Resource children SHALL contain @ID and be referenced from elsewhere within the XJDF. This rule is violated by ResourceSet[Name=%s]", resourceSet.getName()));
        }
    }

    @Override
    public boolean canValidate(Object o) {
        return o instanceof ResourceSet;
    }
}

