/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlPackager;
import org.cip4.lib.xjdf.xml.internal.PackagerException;

public class XJdfPackager
extends AbstractXmlPackager<XJDF> {
    public XJdfPackager(OutputStream out) {
        super(out);
    }

    public XJdfPackager(Path zipPath, OutputStream out) {
        super(zipPath, out);
    }

    public final void packageXjdf(XJDF xjdf) throws PackagerException {
        this.packageXjdf(xjdf, xjdf.getJobID());
    }

    public final void packageXjdf(XJDF xjdf, String docName) throws PackagerException {
        if (StringUtils.isBlank((CharSequence)docName)) {
            docName = IDGeneratorUtil.generateID("XJDF") + ".xjdf";
        } else if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)docName))) {
            docName = docName + ".xjdf";
        }
        this.packageXml(xjdf, docName);
    }

    @Override
    protected final byte[] parseDocument(XJDF xjdf) throws Exception {
        return new XJdfParser().parseXJdf(xjdf);
    }
}

