/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.AbstractXJdfType;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;

public class IDREF
extends AbstractXJdfType<String, IDREF> {
    private final String id;
    private final Object element;

    public IDREF() {
        this.id = "";
        this.element = null;
    }

    public String getId() {
        return this.id;
    }

    public Resource getResource() {
        return (Resource)this.element;
    }

    public Product getProduct() {
        return (Product)this.element;
    }

    public IDREF(SpecificResource specificResource) {
        this(specificResource, null, IDGeneratorUtil.generateID("PAR"));
    }

    public IDREF(SpecificResource specificResource, Part part, String id) {
        this.id = id;
        XJdfNodeFactory nf = new XJdfNodeFactory();
        Resource resource = nf.createResource(specificResource, part);
        resource.setID(this.id);
        this.element = resource;
    }

    public IDREF(Product product) {
        this(product, IDREF.generateId(product));
    }

    public IDREF(Product product, String id) {
        this.id = id;
        product.setID(id);
        this.element = product;
    }

    public IDREF(String expression) {
        this.id = expression;
        this.element = null;
    }

    public String marshal(IDREF idRef) {
        if (idRef == null) {
            return null;
        }
        return idRef.getId();
    }

    public IDREF unmarshal(String v) {
        return new IDREF(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }

    private static String generateId(Product product) {
        String productId = product.getID();
        if (StringUtils.isEmpty((CharSequence)productId)) {
            productId = IDGeneratorUtil.generateID("PRD");
        }
        return productId;
    }
}

