/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class Matrix
extends AbstractXJdfType<String, Matrix> {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double tx;
    private final double ty;

    public Matrix() {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 1.0;
        this.tx = 0.0;
        this.ty = 0.0;
    }

    public Matrix(double a, double b, double c, double d, double tx, double ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public Matrix(double tx, double ty) {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 1.0;
        this.tx = tx;
        this.ty = ty;
    }

    public Matrix(String expression) {
        String[] s = expression.split(" ");
        this.a = Double.valueOf(s[0]);
        this.b = Double.valueOf(s[1]);
        this.c = Double.valueOf(s[2]);
        this.d = Double.valueOf(s[3]);
        this.tx = Double.valueOf(s[4]);
        this.ty = Double.valueOf(s[5]);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getD() {
        return this.d;
    }

    public double getTx() {
        return this.tx;
    }

    public double getTy() {
        return this.ty;
    }

    public String marshal(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        double a = matrix.getA();
        double b = matrix.getB();
        double c = matrix.getC();
        double d = matrix.getD();
        double tx = matrix.getTx();
        double ty = matrix.getTy();
        return String.format("%s %s %s %s %s %s", a, b, c, d, tx, ty);
    }

    public Matrix unmarshal(String v) {
        return new Matrix(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

