/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public abstract class AbstractList<T>
extends AbstractXJdfType<String, AbstractList<T>> {
    private static final String LIST_SEPARATOR = " ";
    private List<T> list;

    public AbstractList() {
        this(new ArrayList());
    }

    public AbstractList(T ... values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        list.addAll(Arrays.asList(values));
        this.list = Collections.unmodifiableList(list);
    }

    public AbstractList(List<T> list) {
        this.list = Collections.unmodifiableList(list);
    }

    public AbstractList(String value) {
        String[] items = value.split(LIST_SEPARATOR);
        ArrayList<T> lst = new ArrayList<T>(items.length);
        for (String item : items) {
            lst.add(this.convertFromString(item));
        }
        this.list = Collections.unmodifiableList(lst);
    }

    public T get(int i) {
        return this.getList().get(i);
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    protected abstract T convertFromString(String var1);

    public String marshal(AbstractList<T> obj) {
        if (obj == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < obj.list.size(); ++i) {
            if (result.length() > 0) {
                result.append(LIST_SEPARATOR);
            }
            result.append(obj.list.get(i).toString());
        }
        return result.toString();
    }

    public AbstractList<T> unmarshal(String v) throws Exception {
        return (AbstractList)((Object)((Object)((Object)this)).getClass().getConstructor(String.class).newInstance(v));
    }
}

