/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractXJdfNodeBuilder;
import org.cip4.lib.xjdf.schema.jdf.Address;
import org.cip4.lib.xjdf.schema.jdf.ComChannel;
import org.cip4.lib.xjdf.schema.jdf.Company;
import org.cip4.lib.xjdf.schema.jdf.Contact;
import org.cip4.lib.xjdf.schema.jdf.Person;

public class ContactBuilder
extends AbstractXJdfNodeBuilder<Contact> {
    private final XJdfNodeFactory xJdfNodeFactory = XJdfNodeFactory.newInstance();

    private ContactBuilder() {
        super(XJdfNodeFactory.newInstance().createContact());
    }

    public static ContactBuilder newInstance() {
        return new ContactBuilder();
    }

    public Contact getContact() {
        return (Contact)this.getNode();
    }

    public ContactBuilder addContactType(String contactType) {
        this.getContact().getContactTypes().add(contactType);
        return this;
    }

    public ContactBuilder addContactType(Object contactType) {
        this.addContactType(contactType.toString());
        return this;
    }

    public ContactBuilder addContactType(Object[] contactTypes) {
        if (contactTypes != null) {
            for (int i = 0; i < contactTypes.length; ++i) {
                this.addContactType(contactTypes[i]);
            }
        }
        return this;
    }

    public ContactBuilder addPerson(String familyName, String firstName, String namePrefix) {
        Person person = this.xJdfNodeFactory.createPerson();
        person.setFamilyName(familyName);
        person.setFirstName(firstName);
        person.setNamePrefix(namePrefix);
        this.getContact().getPersons().add(person);
        return this;
    }

    public ContactBuilder addCompany(String name, String unit) {
        Company company = this.xJdfNodeFactory.createCompany();
        company.setOrganizationName(name);
        company.setOrganizationalUnit(unit);
        this.getContact().getCompanies().add(company);
        return this;
    }

    public ContactBuilder addAddress(String street, String postalCode, String city, String country) {
        Address address = this.xJdfNodeFactory.createAddress();
        address.setStreet(street);
        address.setPostalCode(postalCode);
        address.setCity(city);
        address.setCountry(country);
        this.getContact().getAddresses().add(address);
        return this;
    }

    public ContactBuilder addComChannel(String channelType, String locator) {
        ComChannel comChannel = this.xJdfNodeFactory.createComChannel();
        comChannel.setChannelType(channelType);
        comChannel.setLocator(locator);
        this.getContact().getComChannels().add(comChannel);
        return this;
    }
}

