/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationException;
import org.cip4.lib.xjdf.schema.jdf.XJDF;
import org.cip4.lib.xjdf.util.IOUtils;
import org.cip4.lib.xjdf.xml.XJdfValidator;
import org.cip4.lib.xjdf.xml.internal.JAXBContextFactory;
import org.cip4.lib.xjdf.xml.internal.XJdfNamespaceMapper;

public class XJdfParser {
    private XJdfParser() {
    }

    public static XJdfParser newInstance() {
        return new XJdfParser();
    }

    public void parseXJdf(XJDF xJdf, OutputStream os) throws Exception {
        this.parseXJdf(xJdf, os, false);
    }

    public void parseXJdf(XJDF xJdf, OutputStream os, boolean skipValidation) throws Exception {
        ByteArrayInputStream is;
        Marshaller m = JAXBContextFactory.getInstance().createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new XJdfNamespaceMapper());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        m.marshal((Object)xJdf, (OutputStream)bos);
        bos.close();
        if (!skipValidation) {
            is = new ByteArrayInputStream(bos.toByteArray());
            XJdfValidator validator = XJdfValidator.newInstance();
            validator.check(is);
            if (!validator.isValid()) {
                String err = validator.getMessagesText();
                throw new ValidationException(err);
            }
        }
        is = new ByteArrayInputStream(bos.toByteArray());
        IOUtils.copy(is, os);
    }

    public XJDF parseStream(InputStream is) throws Exception {
        Unmarshaller u = JAXBContextFactory.getInstance().createUnmarshaller();
        XJDF xJdf = (XJDF)u.unmarshal(is);
        return xJdf;
    }
}

