/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XJdfValidator {
    private List<String> messages = null;

    private XJdfValidator() {
    }

    public static XJdfValidator newInstance() {
        return new XJdfValidator();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getMessagesText() {
        String result = null;
        if (!this.isValid()) {
            StringBuilder builder = new StringBuilder();
            builder.append("XJDF Document is invalid:");
            for (String msg : this.messages) {
                builder.append("\n");
                builder.append(msg);
            }
            result = builder.toString();
        }
        return result;
    }

    public XJdfValidator check(InputStream xJdfFileStream) throws Exception {
        this.messages = null;
        InputStream isSchema = XJdfValidator.class.getResourceAsStream("/org/cip4/lib/xjdf/xsd/JDF20.xsd");
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(isSchema);
        Schema schema = schemaFactory.newSchema(schemaSource);
        XJdfErrorHandler errorHandler = new XJdfErrorHandler();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setSchema(schema);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(errorHandler);
        db.parse(xJdfFileStream);
        this.messages = errorHandler.getMessages();
        return this;
    }

    public boolean isValid() {
        if (this.messages == null) {
            throw new NullPointerException("No XJDF Document was checked. Check a document before calling this method.");
        }
        return this.messages.size() == 0;
    }

    private class XJdfErrorHandler
    implements ErrorHandler {
        private final List<String> messages = new ArrayList<String>();

        private XJdfErrorHandler() {
        }

        public List<String> getMessages() {
            return this.messages;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            String msg = "WARNING in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            String msg = "ERROR in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            String msg = "FATAL in XJDF Doc ERROR at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }
    }
}

