/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathNavigator {
    private final XPath xPath;
    private final Document xmlDocument;

    private XPathNavigator(InputStream xJdfStream) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.xmlDocument = docBuilder.parse(new InputSource(xJdfStream));
        xJdfStream.close();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xPath = xPathFactory.newXPath();
    }

    public static XPathNavigator newInstance(InputStream xJdfStream) throws Exception {
        return new XPathNavigator(xJdfStream);
    }

    public String readAttribute(String xPath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.xPath.evaluate(xPath, this.xmlDocument, XPathConstants.NODESET);
        String result = nodes.getLength() > 0 ? nodes.item(0).getNodeValue() : null;
        return result;
    }

    public void updateAttribute(String xPath, String value) throws Exception {
        String exprString = xPath;
        Attr result = (Attr)this.xPath.evaluate(exprString, this.xmlDocument, XPathConstants.NODE);
        result.setValue(value);
    }

    public InputStream getXJdfStream() throws Exception {
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        xformer.transform(new DOMSource(this.xmlDocument), new StreamResult(bos));
        ByteArrayInputStream resultStream = new ByteArrayInputStream(bos.toByteArray());
        bos.close();
        return resultStream;
    }
}

