/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class DateTime
extends AbstractXJdfType<String, DateTime> {
    private static final TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    private final DateFormat DATE_FORMAT_UTC = DateTime.createUTCDateFormat();
    private final DateFormat DATE_FORMAT_WITH_TIME_ZONE_RFC_822 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final DateFormat DATE_FORMAT_WITH_TIME_ZONE_ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private final Calendar calendar = Calendar.getInstance(TIME_ZONE_UTC);

    public DateTime() {
    }

    public DateTime(int year, int month, int day) {
        this(year, month, day, 0, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute) {
        this(year, month, day, hour, minute, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.calendar.set(year, month, day, hour, minute, second);
    }

    public DateTime(String dateTime) throws ParseException {
        try {
            this.calendar.setTime(this.DATE_FORMAT_UTC.parse(dateTime));
        }
        catch (ParseException e1) {
            try {
                this.calendar.setTime(this.DATE_FORMAT_WITH_TIME_ZONE_RFC_822.parse(dateTime));
            }
            catch (ParseException e2) {
                this.calendar.setTime(this.DATE_FORMAT_WITH_TIME_ZONE_ISO_8601.parse(dateTime));
            }
        }
    }

    public DateTime(Date date) {
        this.calendar.setTime(date);
    }

    public final Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    private static DateFormat createUTCDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TIME_ZONE_UTC);
        return dateFormat;
    }

    public final String marshal(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toString();
    }

    public final DateTime unmarshal(String dateTime) throws Exception {
        return new DateTime(dateTime);
    }

    @Override
    public final String toString() {
        return this.DATE_FORMAT_UTC.format(this.calendar.getTime());
    }

    public final String toString(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone has not been specified");
        }
        this.DATE_FORMAT_WITH_TIME_ZONE_ISO_8601.setTimeZone(timeZone);
        return this.DATE_FORMAT_WITH_TIME_ZONE_ISO_8601.format(this.calendar.getTime());
    }
}

