/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.cip4.lib.xjdf.schema.Part;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Partitions {
    private static final List<Method> GETTERS = Partitions.readGetters();

    private Partitions() {
    }

    public static boolean hasMismatchingAttributes(@NotNull Part partition1, @NotNull Part partition2) {
        for (Method method : GETTERS) {
            try {
                Object partAttr2;
                Object partAttr1 = method.invoke((Object)partition1, new Object[0]);
                if (Partitions.isEmptyAttributeValue(partAttr1) || Partitions.isEmptyAttributeValue(partAttr2 = method.invoke((Object)partition2, new Object[0])) || partAttr1.equals(partAttr2)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not access public getter method.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke getter of Part object.", e);
            }
        }
        return false;
    }

    private static boolean isEmptyAttributeValue(@Nullable Object attribute) {
        if (attribute instanceof List) {
            return ((List)attribute).isEmpty();
        }
        return attribute == null;
    }

    @NotNull
    static List<Method> readGetters() {
        ArrayList<Method> getters = new ArrayList<Method>();
        for (Method method : Part.class.getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || !method.getDeclaringClass().equals(Part.class)) continue;
            getters.add(method);
        }
        return getters;
    }
}

