/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Ancestors {
    private final List<Object> ancestors;

    public Ancestors() {
        this.ancestors = Collections.emptyList();
    }

    public Ancestors(Object ... ancestors) {
        this.ancestors = Arrays.asList(ancestors);
    }

    private Ancestors(List<Object> ancestors) {
        this.ancestors = ancestors;
    }

    public Ancestors push(Object child) {
        ArrayList<Object> ancestors = new ArrayList<Object>(this.ancestors);
        ancestors.add(child);
        return new Ancestors(Collections.unmodifiableList(ancestors));
    }

    public <T> T getNearestAncestor(Class<T> type) {
        for (int i = this.ancestors.size() - 1; i >= 0; --i) {
            if (!type.isInstance(this.ancestors.get(i))) continue;
            return (T)this.ancestors.get(i);
        }
        return null;
    }

    public Object parent() {
        if (this.ancestors.isEmpty()) {
            return null;
        }
        return this.ancestors.get(this.ancestors.size() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ancestors ancestors1 = (Ancestors)o;
        return Objects.equals(this.ancestors, ancestors1.ancestors);
    }

    public int hashCode() {
        return Objects.hash(this.ancestors);
    }
}

