/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator.element;

import java.util.Arrays;
import java.util.List;
import org.cip4.lib.xjdf.schema.DeliveryParams;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.SimpleValidator;

public class DeliveryParamsValidator
extends SimpleValidator<DeliveryParams> {
    private final List<String> allowedResourceUsages = Arrays.asList("DeliveryContents", "MailingList", "RemoteURL");

    @Override
    public void validate(DeliveryParams deliveryParams, Ancestors ancestors, ValidationResultBuilder validationResult) {
        List<FileSpec> fileSpecs = deliveryParams.getFileSpec();
        for (String resourceUsage : this.allowedResourceUsages) {
            validationResult.append(this.validateResourceUsageCount(fileSpecs, resourceUsage));
        }
        for (FileSpec fileSpec : fileSpecs) {
            if (this.allowedResourceUsages.contains(fileSpec.getResourceUsage())) continue;
            validationResult.append(String.format("FileSpec with @ResourceUsage='%s' is not allowed within element '//DeliveryParams'.", fileSpec.getResourceUsage()));
        }
    }

    @Override
    public boolean canValidate(Object o) {
        return o instanceof DeliveryParams;
    }

    final ValidationResult validateResourceUsageCount(List<FileSpec> fileSpecs, String resourceUsage) {
        int count = 0;
        for (FileSpec fileSpec : fileSpecs) {
            if (!resourceUsage.equals(fileSpec.getResourceUsage())) continue;
            ++count;
        }
        if (count > 1) {
            return new ValidationResult(String.format("FileSpec with @ResourceUsage='%s' is only allowed once within element '//DeliveryParams' but %d are present.", fileSpecs, count));
        }
        return new ValidationResult(new String[0]);
    }
}

