/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.IntentType;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class ProductBuilder
extends AbstractNodeBuilder<Product> {
    private final XJdfNodeFactory xJdfNodeFactory = XJdfNodeFactory.newInstance();

    private ProductBuilder() {
        super(XJdfNodeFactory.newInstance().createProduct());
    }

    public static ProductBuilder newInstance() {
        return new ProductBuilder();
    }

    public static ProductBuilder newInstance(int amount) {
        return ProductBuilder.newInstance(amount, null, null, null);
    }

    public static ProductBuilder newInstance(int amount, String productId, String productType, String productTypeDetails) {
        ProductBuilder builder = ProductBuilder.newInstance();
        builder.getProduct().setAmount(amount);
        builder.getProduct().setID(productId);
        builder.getProduct().setProductType(productType);
        builder.getProduct().setProductTypeDetails(productTypeDetails);
        return builder;
    }

    protected Product getProduct() {
        return (Product)this.getNode();
    }

    public ProductBuilder addIntent(IntentType intent) {
        String intentName = intent.getClass().getSimpleName();
        Intent it = this.xJdfNodeFactory.createIntent();
        it.setName(intentName);
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, intentName);
        JAXBElement obj = new JAXBElement(qname, intent.getClass(), null, (Object)intent);
        it.getIntentTypes().add((JAXBElement<? extends IntentType>)obj);
        this.getProduct().getIntents().add(it);
        return this;
    }
}

