/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Parameter;
import org.cip4.lib.xjdf.schema.ParameterSet;
import org.cip4.lib.xjdf.schema.ParameterType;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class XJdfBuilder
extends AbstractNodeBuilder<XJDF> {
    private final XJdfNodeFactory xJdfNodeFactory;
    private final Map<String, ParameterSet> mapParameterSets = new HashMap<String, ParameterSet>(20);

    private XJdfBuilder() {
        super(XJdfNodeFactory.newInstance().createXJDF());
        this.xJdfNodeFactory = XJdfNodeFactory.newInstance();
    }

    public static XJdfBuilder newInstance() {
        return new XJdfBuilder();
    }

    public static XJdfBuilder newInstance(String jobID) {
        return XJdfBuilder.newInstance(jobID, "Web2Print", null, null);
    }

    public static XJdfBuilder newInstance(String jobID, String category) {
        return XJdfBuilder.newInstance(jobID, category, null, null);
    }

    public static XJdfBuilder newInstance(String jobID, String category, String descriptiveName) {
        return XJdfBuilder.newInstance(jobID, category, descriptiveName, null);
    }

    public static XJdfBuilder newInstance(String jobID, String category, String descriptiveName, String relatedJobID) {
        XJdfBuilder xJdfBuilder = XJdfBuilder.newInstance();
        xJdfBuilder.getXJdf().setJobID(jobID);
        xJdfBuilder.getXJdf().setCategory(category);
        xJdfBuilder.getXJdf().setDescriptiveName(descriptiveName);
        xJdfBuilder.getXJdf().setRelatedJobID(relatedJobID);
        return xJdfBuilder;
    }

    protected XJDF getXJdf() {
        return (XJDF)this.getNode();
    }

    public XJdfBuilder addGeneralID(GeneralID generalId) {
        this.getXJdf().getGeneralIDs().add(generalId);
        return this;
    }

    public XJdfBuilder addProduct(Product product) {
        if (this.getXJdf().getProductList() == null) {
            this.getXJdf().setProductList(this.xJdfNodeFactory.createProductList());
        }
        this.getXJdf().getProductList().getProducts().add(product);
        return this;
    }

    public XJdfBuilder addParameter(ParameterType parameter) {
        return this.addParameter(parameter, null);
    }

    public XJdfBuilder addParameter(ParameterType parameter, Part part) {
        ParameterSet parameterSet;
        String paramName = parameter.getClass().getSimpleName();
        Parameter param = this.xJdfNodeFactory.createParameter();
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
        JAXBElement obj = new JAXBElement(qname, parameter.getClass(), null, (Object)parameter);
        param.getParameterTypes().add((JAXBElement<? extends ParameterType>)obj);
        if (part != null) {
            param.getParts().add(part);
        }
        if (this.mapParameterSets.containsKey(paramName)) {
            parameterSet = this.mapParameterSets.get(paramName);
        } else {
            parameterSet = this.xJdfNodeFactory.createParameterSet();
            parameterSet.setName(paramName);
            this.getXJdf().getSetTypes().add(this.xJdfNodeFactory.createParameterSet(parameterSet));
            this.mapParameterSets.put(paramName, parameterSet);
        }
        parameterSet.getParameters().add(param);
        return this;
    }
}

