/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateConverter {
    private static final String patternUTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String patternGlobal = "yyyy-MM-dd'T'HH:mm:ssXXX";

    private DateConverter() {
        throw new AssertionError((Object)"Class cannot be instantiated.");
    }

    public static String date2String(Calendar calendar) {
        SimpleDateFormat dateFormat = calendar.getTimeZone().getRawOffset() == 0 ? new SimpleDateFormat(patternUTC) : new SimpleDateFormat(patternGlobal);
        dateFormat.setTimeZone(calendar.getTimeZone());
        String result = dateFormat.format(calendar.getTime());
        return result;
    }

    public static Calendar string2Date(String strDate) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(patternGlobal);
        dateFormat.parse(strDate);
        Calendar result = dateFormat.getCalendar();
        String[] ids = TimeZone.getAvailableIDs(result.get(15));
        result.setTimeZone(TimeZone.getTimeZone(ids[0]));
        return result;
    }
}

