/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationException;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.xml.XJdfValidator;
import org.cip4.lib.xjdf.xml.internal.XJdfNamespaceMapper;

public abstract class AbstractXmlParser<T> {
    private final JAXBContext jaxbContext;

    protected AbstractXmlParser(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    protected void parseXml(T obj, OutputStream os) throws Exception {
        this.parseXml(obj, os, false);
    }

    protected void parseXml(T obj, OutputStream os, boolean skipValidation) throws Exception {
        ByteArrayInputStream is;
        XJdfValidator validator;
        Marshaller m = this.jaxbContext.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new XJdfNamespaceMapper());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        m.marshal(obj, (OutputStream)bos);
        bos.close();
        if (!skipValidation && !(validator = XJdfValidator.newInstance(is = new ByteArrayInputStream(bos.toByteArray()))).isValid()) {
            String err = validator.getMessagesText();
            throw new ValidationException(err);
        }
        is = new ByteArrayInputStream(bos.toByteArray());
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    protected T parseStream(InputStream is) throws Exception {
        Unmarshaller u = this.jaxbContext.createUnmarshaller();
        Object dom = u.unmarshal(is);
        return (T)dom;
    }
}

