/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.Address;
import org.cip4.lib.xjdf.schema.ComChannel;
import org.cip4.lib.xjdf.schema.Company;
import org.cip4.lib.xjdf.schema.Contact;
import org.cip4.lib.xjdf.schema.Person;

public class ContactBuilder
extends AbstractNodeBuilder<Contact> {
    private final XJdfNodeFactory xJdfNodeFactory = new XJdfNodeFactory();

    public ContactBuilder() {
        super(new XJdfNodeFactory().createContact());
    }

    protected Contact getContact() {
        return (Contact)this.getNode();
    }

    public void addContactType(String contactType) {
        this.getContact().getContactTypes().add(contactType);
    }

    public void addContactType(Object contactType) {
        this.addContactType(contactType.toString());
    }

    public void addContactType(Object[] contactTypes) {
        if (contactTypes != null) {
            for (int i = 0; i < contactTypes.length; ++i) {
                this.addContactType(contactTypes[i]);
            }
        }
    }

    public Person addPerson(String familyName, String firstName, String namePrefix) {
        Person person = this.xJdfNodeFactory.createPerson();
        person.setFamilyName(familyName);
        person.setFirstName(firstName);
        person.setNamePrefix(namePrefix);
        this.getContact().getPerson().add(person);
        return person;
    }

    public Company addCompany(String organizationName) {
        return this.addCompany(organizationName, null);
    }

    public Company addCompany(String organizationName, String unit) {
        Company company = this.xJdfNodeFactory.createCompany();
        company.setOrganizationName(organizationName);
        company.setOrganizationalUnit(unit);
        this.getContact().getCompany().add(company);
        return company;
    }

    public Address addAddress(String street, String postalCode, String city) {
        return this.addAddress(street, postalCode, city, null, null);
    }

    public Address addAddress(String street, String postalCode, String city, String country, String countryCode) {
        Address address = this.xJdfNodeFactory.createAddress();
        address.setStreet(street);
        address.setPostalCode(postalCode);
        address.setCity(city);
        address.setCountry(country);
        address.setCountryCode(countryCode);
        this.getContact().getAddress().add(address);
        return address;
    }

    public ComChannel addComChannel(String channelType, String locator) {
        return this.addComChannel(channelType, locator, null);
    }

    public ComChannel addComChannel(String channelType, String locator, String channelTypeDetails) {
        ComChannel comChannel = this.xJdfNodeFactory.createComChannel();
        comChannel.setChannelType(channelType);
        comChannel.setLocator(locator);
        comChannel.setChannelTypeDetails(channelTypeDetails);
        this.getContact().getComChannel().add(comChannel);
        return comChannel;
    }
}

