/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationException;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.ChildProduct;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.IntentType;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class ProductBuilder
extends AbstractNodeBuilder<Product> {
    private static final String ID_PREFIX = "PRD";
    private final XJdfNodeFactory xJdfNodeFactory = new XJdfNodeFactory();

    public ProductBuilder() {
        this(null, null, null, null);
    }

    public ProductBuilder(Integer amount) {
        this(amount, null, null, null);
    }

    public ProductBuilder(Integer amount, String productType, String productTypeDetails) {
        this(amount, productType, productTypeDetails, null);
    }

    public ProductBuilder(Integer amount, String productType, String productTypeDetails, String descriptiveName) {
        super(new XJdfNodeFactory().createProduct());
        this.getProduct().setAmount(amount);
        this.getProduct().setProductType(productType);
        this.getProduct().setProductTypeDetails(productTypeDetails);
        this.getProduct().setDescriptiveName(descriptiveName);
    }

    protected Product getProduct() {
        return (Product)this.getNode();
    }

    public ProductBuilder addIntent(IntentType intent) {
        if (intent == null) {
            return this;
        }
        String intentName = intent.getClass().getSimpleName();
        Intent it = this.xJdfNodeFactory.createIntent();
        it.setName(intentName);
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, intentName);
        JAXBElement obj = new JAXBElement(qname, intent.getClass(), null, (Object)intent);
        it.getIntentType().add((JAXBElement<? extends IntentType>)obj);
        this.getProduct().getIntent().add(it);
        return this;
    }

    public ProductBuilder addChildProduct(Product product) throws ValidationException {
        if (((Product)this.getNode()).getID() == null || ((Product)this.getNode()).getID().equals("")) {
            ((Product)this.getNode()).setID(IDGeneratorUtil.generateID(ID_PREFIX));
        }
        if (product.getID() == null || product.getID().equals("")) {
            product.setID(IDGeneratorUtil.generateID(ID_PREFIX));
        }
        ChildProduct childProduct = this.xJdfNodeFactory.createChildProduct();
        childProduct.setChildRef(product);
        this.getProduct().getChildProduct().add(childProduct);
        this.getProduct().setIsRoot(true);
        if (product.getChildProduct().size() > 0) {
            throw new ValidationException("A Child Product cannot have children!");
        }
        return this;
    }
}

