/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.ChildProduct;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Parameter;
import org.cip4.lib.xjdf.schema.ParameterSet;
import org.cip4.lib.xjdf.schema.ParameterType;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class XJdfBuilder
extends AbstractNodeBuilder<XJDF> {
    private final XJdfNodeFactory xJdfNodeFactory;
    private final Map<String, ParameterSet> mapParameterSets = new HashMap<String, ParameterSet>(20);

    public XJdfBuilder() {
        this(null, null, null, null);
    }

    public XJdfBuilder(String jobID) {
        this(jobID, "Web2Print", null, null);
    }

    public XJdfBuilder(String jobID, String category) {
        this(jobID, category, null, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName) {
        this(jobID, category, descriptiveName, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName, String relatedJobID) {
        super(new XJdfNodeFactory().createXJDF());
        this.xJdfNodeFactory = new XJdfNodeFactory();
        this.getXJdf().setJobID(jobID);
        this.getXJdf().setCategory(category);
        this.getXJdf().setDescriptiveName(descriptiveName);
        this.getXJdf().setRelatedJobID(relatedJobID);
        this.getXJdf().setVersion("2.0");
        this.getXJdf().setID(IDGeneratorUtil.generateID("XJDF"));
    }

    protected XJDF getXJdf() {
        return (XJDF)this.getNode();
    }

    public XJdfBuilder addComment(String comment) {
        Comment obj = this.xJdfNodeFactory.createComment(comment);
        ((XJDF)this.getNode()).getComment().add(obj);
        return this;
    }

    public XJdfBuilder addGeneralID(GeneralID generalId) {
        if (generalId == null) {
            return this;
        }
        this.getXJdf().getGeneralID().add(generalId);
        return this;
    }

    public XJdfBuilder addProduct(Product product) {
        if (product == null) {
            return this;
        }
        if (this.getXJdf().getProductList() == null) {
            this.getXJdf().setProductList(this.xJdfNodeFactory.createProductList());
        }
        this.getXJdf().getProductList().getProduct().add(product);
        for (ChildProduct child : product.getChildProduct()) {
            this.getXJdf().getProductList().getProduct().add((Product)child.getChildRef());
        }
        return this;
    }

    public XJdfBuilder addParameter(ParameterType parameter) {
        return this.addParameter(parameter, null);
    }

    public XJdfBuilder addParameter(List<ParameterType> parameters) {
        for (ParameterType parameter : parameters) {
            this.addParameter(parameter, null);
        }
        return this;
    }

    public XJdfBuilder addParameter(ParameterType parameter, Part part) {
        ParameterSet parameterSet;
        if (parameter == null) {
            return this;
        }
        String paramName = parameter.getClass().getSimpleName();
        Parameter param = this.xJdfNodeFactory.createParameter();
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
        JAXBElement obj = new JAXBElement(qname, parameter.getClass(), null, (Object)parameter);
        param.getParameterType().add((JAXBElement<? extends ParameterType>)obj);
        if (part != null) {
            param.getPart().add(part);
        }
        if (this.mapParameterSets.containsKey(paramName)) {
            parameterSet = this.mapParameterSets.get(paramName);
        } else {
            parameterSet = this.xJdfNodeFactory.createParameterSet();
            parameterSet.setName(paramName);
            this.getXJdf().getSetType().add(this.xJdfNodeFactory.createParameterSet(parameterSet));
            this.mapParameterSets.put(paramName, parameterSet);
        }
        parameterSet.getParameter().add(param);
        return this;
    }
}

