/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public abstract class AbstractList<T>
extends AbstractXJdfType<String, AbstractList<T>> {
    private static final String LIST_SEPARATOR = " ";
    private List<T> list;

    public AbstractList() {
        this(new ArrayList());
    }

    public AbstractList(T ... values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i]);
        }
        this.list = Collections.unmodifiableList(list);
    }

    public AbstractList(List<T> list) {
        this.list = Collections.unmodifiableList(list);
    }

    public AbstractList(String value) {
        String[] items = value.split(LIST_SEPARATOR);
        ArrayList<T> lst = new ArrayList<T>(items.length);
        for (int i = 0; i < items.length; ++i) {
            lst.add(this.convertFromString(items[i]));
        }
        this.list = Collections.unmodifiableList(lst);
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    protected abstract T convertFromString(String var1);

    public String marshal(AbstractList<T> obj) {
        if (obj == null) {
            return null;
        }
        String result = null;
        for (int i = 0; i < obj.list.size(); ++i) {
            result = result == null ? obj.list.get(i).toString() : result + LIST_SEPARATOR + obj.list.get(i).toString();
        }
        return result;
    }

    public AbstractList<T> unmarshal(String v) throws Exception {
        return (AbstractList)((Object)((Object)((Object)this)).getClass().getConstructor(String.class).newInstance(v));
    }
}

