/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class Rectangle
extends AbstractXJdfType<String, Rectangle> {
    private final double llx;
    private final double lly;
    private final double urx;
    private final double ury;

    public Rectangle() {
        this.llx = 0.0;
        this.lly = 0.0;
        this.urx = 0.0;
        this.ury = 0.0;
    }

    public Rectangle(double llx, double lly, double urx, double ury) {
        this.llx = llx;
        this.lly = lly;
        this.urx = urx;
        this.ury = ury;
    }

    public Rectangle(String expression) {
        String[] s = expression.split(" ");
        this.llx = Double.valueOf(s[0]);
        this.lly = Double.valueOf(s[1]);
        this.urx = Double.valueOf(s[2]);
        this.ury = Double.valueOf(s[3]);
    }

    public double getLlx() {
        return this.llx;
    }

    public double getLly() {
        return this.lly;
    }

    public double getUrx() {
        return this.urx;
    }

    public double getUry() {
        return this.ury;
    }

    public String marshal(Rectangle v) {
        if (v == null) {
            return null;
        }
        double llx = v.getLlx();
        double lly = v.getLly();
        double urx = v.getUrx();
        double ury = v.getUry();
        String result = String.format("%s %s %s %s", llx, lly, urx, ury);
        return result;
    }

    public Rectangle unmarshal(String v) throws Exception {
        return new Rectangle(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

