/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.cip4.lib.xjdf.xml.internal.NamespaceManager;
import org.xml.sax.InputSource;

public class XJdfConstants {
    public static final String NAMESPACE_JDF20 = XJdfConstants.loadNamespaceJdf20();
    public static final String XJDF_LIB_VERSION = XJdfConstants.loadLibraryVersion();
    public static final String XJDF_LIB_BUILD_DATE = XJdfConstants.loadLibraryBuildDate();
    public static final String NAMESPACE_W3_XML = "http://www.w3.org/2001/XMLSchema";
    public static final String XJDF_CURRENT_VERSION = "2.0";
    public static final String JMF_ICS_VERSION = "JMF_L1-2.0";
    public static final String MEDIA_TYPE_VND_JMF = "application/vnd.cip4-jmf+xml";
    public static final String MEDIA_TYPE_VND_JDF = "application/vnd.cip4-jdf+xml";
    private static final String RES_BUILD_PROPS = "/org/cip4/lib/xjdf/build.properties";
    static final String RES_JDF20_XSD = "/org/cip4/lib/xjdf/xsd/JDF20.xsd";

    private static String loadNamespaceJdf20() {
        String result;
        NamespaceManager nsManager = new NamespaceManager();
        nsManager.addNamespace("xs", NAMESPACE_W3_XML);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(nsManager);
        try {
            XPathExpression xPathExpression = xPath.compile("/xs:schema/@targetNamespace");
            InputStream is = XJdfConstants.class.getResourceAsStream(RES_JDF20_XSD);
            result = xPathExpression.evaluate(new InputSource(is));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        return result;
    }

    private static String loadLibraryVersion() {
        String result = null;
        Properties props = new Properties();
        try {
            props.load(XJdfConstants.class.getResourceAsStream(RES_BUILD_PROPS));
            result = props.getProperty("version", "UNKNOWN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    private static String loadLibraryBuildDate() {
        String result = null;
        Properties props = new Properties();
        try {
            props.load(XJdfConstants.class.getResourceAsStream(RES_BUILD_PROPS));
            result = props.getProperty("build.date", "UNKNOWN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            result = "";
        }
        return result;
    }
}

