/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.xml.internal.XPathNavigatorBase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlPackager {
    private CompressionLevel compressionLevel;
    private final Map<String, File> fileMap;
    private final XPathNavigatorBase xPathNav;
    private final byte[] xmlDoc;

    public AbstractXmlPackager(byte[] xmlDoc) throws Exception {
        ByteArrayInputStream isXml = new ByteArrayInputStream(xmlDoc);
        this.xPathNav = new XPathNavigatorBase(isXml);
        this.compressionLevel = CompressionLevel.DEFAULT_COMPRESSION;
        this.fileMap = new HashMap<String, File>();
        this.xmlDoc = xmlDoc;
    }

    protected byte[] getXmlDoc() {
        return this.xmlDoc;
    }

    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(CompressionLevel compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    protected void packageXml(OutputStream os, String docName) throws Exception {
        ZipOutputStream zout = new ZipOutputStream(os);
        zout.setLevel(this.compressionLevel.getLevel());
        ZipEntry zipEntryXml = new ZipEntry(docName);
        zout.putNextEntry(zipEntryXml);
        InputStream isXJdf = this.xPathNav.getXmlStream();
        IOUtils.copy((InputStream)isXJdf, (OutputStream)zout);
        isXJdf.close();
        for (String key : this.fileMap.keySet()) {
            FileInputStream fis = new FileInputStream(this.fileMap.get(key));
            ZipEntry zipEntryFile = new ZipEntry(key);
            zout.putNextEntry(zipEntryFile);
            IOUtils.copy((InputStream)fis, (OutputStream)zout);
            fis.close();
        }
        zout.finish();
    }

    protected void registerFiles(String xPathAttribute, String targetDir) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.xPathNav.evaluate(xPathAttribute, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            File file = new File(node.getTextContent());
            if (!file.isFile()) continue;
            String fileName = FilenameUtils.concat((String)targetDir, (String)file.getName());
            fileName = FilenameUtils.separatorsToUnix((String)fileName);
            node.setNodeValue(fileName);
            this.fileMap.put(fileName, file);
        }
    }

    public static enum CompressionLevel {
        BEST_SPEED(1),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1),
        NO_COMPRESSION(0);

        private final int level;

        private CompressionLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

