/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.xml.XJdfValidator;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXmlValidator<T> {
    private final List<String> messages;
    private final byte[] xsdFile;
    private final String xsdResPath;
    private final InputStream fileStream;
    private Boolean documentIsValid;

    public AbstractXmlValidator(String xsdResPath, InputStream fileStream) throws IOException {
        InputStream is = XJdfValidator.class.getResourceAsStream(xsdResPath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.close();
        is.close();
        this.messages = new ArrayList<String>();
        this.xsdFile = bos.toByteArray();
        this.fileStream = fileStream;
        this.documentIsValid = null;
        this.xsdResPath = xsdResPath;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getMessagesText() {
        String result = null;
        if (!this.documentIsValid.booleanValue()) {
            StringBuilder builder = new StringBuilder();
            builder.append("XJDF Document is invalid:");
            for (String msg : this.messages) {
                builder.append("\n");
                builder.append(msg);
            }
            result = builder.toString();
        }
        return result;
    }

    private T validate() throws SAXException, ParserConfigurationException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ByteArrayInputStream isSchema = new ByteArrayInputStream(this.xsdFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new ResourceResolver());
        StreamSource schemaSource = new StreamSource(isSchema);
        Schema schema = schemaFactory.newSchema(schemaSource);
        XJdfErrorHandler errorHandler = new XJdfErrorHandler();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setSchema(schema);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(errorHandler);
        db.parse(this.fileStream);
        if (errorHandler.getMessages() != null) {
            this.messages.addAll(errorHandler.getMessages());
        }
        return (T)this;
    }

    public boolean isValid() throws ClassNotFoundException, IllegalAccessException, InstantiationException, SAXException, ParserConfigurationException, IOException {
        if (this.documentIsValid == null) {
            this.validate();
            this.documentIsValid = this.messages.size() == 0;
        }
        return this.documentIsValid;
    }

    private class ResourceResolver
    implements LSResourceResolver {
        private DOMImplementationLS domImplementationLS;

        private ResourceResolver() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            this.domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LSInput lsInput = this.domImplementationLS.createLSInput();
            InputStream is = this.getClass().getResourceAsStream(FilenameUtils.getFullPath((String)AbstractXmlValidator.this.xsdResPath) + systemId);
            lsInput.setByteStream(is);
            lsInput.setSystemId(systemId);
            return lsInput;
        }
    }

    class XJdfErrorHandler
    implements ErrorHandler {
        private final List<String> messages = new ArrayList<String>();

        private XJdfErrorHandler() {
        }

        public List<String> getMessages() {
            return this.messages;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            String msg = "WARNING in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            String msg = "ERROR in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            String msg = "FATAL in XJDF Doc ERROR at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }
    }
}

