/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.cip4.lib.xjdf.type.AbstractXJdfType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XPathNavigatorBase {
    protected final XPath xPath;
    protected final Document xmlDocument;

    protected XPathNavigatorBase(byte[] xmlBytes) throws Exception {
        this(new ByteArrayInputStream(xmlBytes));
    }

    protected XPathNavigatorBase(InputStream xmlStream) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.xmlDocument = docBuilder.parse(new InputSource(xmlStream));
        xmlStream.close();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xPath = xPathFactory.newXPath();
    }

    public String readAttribute(String xPath) throws XPathExpressionException {
        return (String)this.evaluate(xPath, XPathConstants.STRING);
    }

    public Object readAttribute(String xPath, Class xJdfType) throws XPathExpressionException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String value = (String)this.evaluate(xPath, XPathConstants.STRING);
        Constructor ctor = xJdfType.getDeclaredConstructor(String.class);
        AbstractXJdfType validator = (AbstractXJdfType)((Object)ctor.newInstance(value));
        return validator;
    }

    public Object evaluate(String xPath, QName qname) throws XPathExpressionException {
        Object result = this.xPath.evaluate(xPath, this.xmlDocument, qname);
        return result;
    }

    public void updateAttribute(String xPath, AbstractXJdfType value) throws Exception {
        this.updateAttribute(xPath, value.toString());
    }

    public void updateAttribute(String xPath, String value) throws Exception {
        String exprString = xPath;
        Attr result = (Attr)this.evaluate(exprString, XPathConstants.NODE);
        result.setValue(value);
    }

    public InputStream getXmlStream() throws Exception {
        ByteArrayInputStream resultStream = new ByteArrayInputStream(this.getXmlBytes());
        return resultStream;
    }

    public byte[] getXmlBytes() throws Exception {
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        xformer.transform(new DOMSource(this.xmlDocument), new StreamResult(bos));
        bos.close();
        return bos.toByteArray();
    }
}

