/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.comparator.SetTypeComparator;
import org.cip4.lib.xjdf.schema.Audit;
import org.cip4.lib.xjdf.schema.AuditPool;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Parameter;
import org.cip4.lib.xjdf.schema.ParameterSet;
import org.cip4.lib.xjdf.schema.ParameterType;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.SetType;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class XJdfBuilder
extends AbstractNodeBuilder<XJDF> {
    private final XJdfNodeFactory xJdfNodeFactory;
    private final Map<String, ParameterSet> mapParameterSets = new HashMap<String, ParameterSet>(20);

    public XJdfBuilder() {
        this(null, null, null, null);
    }

    public XJdfBuilder(String jobID) {
        this(jobID, null, null, null);
    }

    public XJdfBuilder(String jobID, String category) {
        this(jobID, category, null, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName) {
        this(jobID, category, descriptiveName, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName, String relatedJobID) {
        super(new XJdfNodeFactory().createXJDF());
        this.xJdfNodeFactory = new XJdfNodeFactory();
        this.getXJdf().setJobID(jobID);
        this.getXJdf().setCategory(category);
        this.getXJdf().setDescriptiveName(descriptiveName);
        this.getXJdf().setRelatedJobID(relatedJobID);
        this.getXJdf().setVersion("2.0");
        this.getXJdf().setID(IDGeneratorUtil.generateID("XJDF"));
    }

    public XJdfBuilder(XJDF xjdf) {
        super(xjdf);
        this.xJdfNodeFactory = new XJdfNodeFactory();
        for (JAXBElement<? extends SetType> setType : xjdf.getSetType()) {
            if (!(setType.getValue() instanceof ParameterSet)) continue;
            ParameterSet parameterSet = (ParameterSet)setType.getValue();
            String key = parameterSet.getName();
            if (parameterSet.getProcessUsage() != null) {
                key = key + "_" + parameterSet.getProcessUsage();
            }
            this.mapParameterSets.put(key, parameterSet);
        }
        Collections.sort(this.getXJdf().getSetType(), new SetTypeComparator());
    }

    public XJDF getXJdf() {
        return (XJDF)this.getNode();
    }

    public void addComment(String comment) {
        Comment obj = this.xJdfNodeFactory.createComment(comment);
        ((XJDF)this.getNode()).getComment().add(obj);
    }

    public void addAudit(Audit audit) {
        if (audit == null) {
            return;
        }
        String paramName = audit.getClass().getSimpleName();
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
        JAXBElement obj = new JAXBElement(qname, audit.getClass(), null, (Object)audit);
        if (this.getXJdf().getAuditPool() == null) {
            AuditPool auditPool = this.xJdfNodeFactory.createAuditPool();
            this.getXJdf().setAuditPool(auditPool);
        }
        this.getXJdf().getAuditPool().getAudit().add((JAXBElement<? extends Audit>)obj);
    }

    public void addGeneralID(GeneralID generalId) {
        if (generalId == null) {
            return;
        }
        this.getXJdf().getGeneralID().add(generalId);
    }

    public void addProduct(Product product) {
        if (product == null) {
            return;
        }
        if (this.getXJdf().getProductList() == null) {
            this.getXJdf().setProductList(this.xJdfNodeFactory.createProductList());
        }
        this.getXJdf().getProductList().getProduct().add(product);
    }

    public void addParameter(ParameterType parameterType) {
        this.addParameter(parameterType, null, null);
    }

    public void addParameter(ParameterType parameterType, String processUsage) {
        this.addParameter(parameterType, null, processUsage);
    }

    public void addParameter(List<ParameterType> parameterTypes) {
        this.addParameter(parameterTypes, null);
    }

    public void addParameter(List<ParameterType> parameterTypes, String processUsage) {
        for (ParameterType parameter : parameterTypes) {
            this.addParameter(parameter, null, processUsage);
        }
    }

    public void addParameter(ParameterType parameterType, Part part) {
        this.addParameter(parameterType, part, null);
    }

    public void addParameter(ParameterType parameterType, Part part, String processUsage) {
        if (parameterType == null) {
            return;
        }
        Parameter parameter = this.xJdfNodeFactory.createParameter(parameterType, part);
        this.addParameter(parameter, processUsage);
    }

    public void addParameter(Parameter parameter) {
        this.addParameter(parameter, null);
    }

    public void addParameter(Parameter parameter, String processUsage) {
        ParameterSet parameterSet;
        String paramName;
        String key = paramName = parameter.getParameterType().getName().getLocalPart();
        if (!StringUtils.isEmpty((String)processUsage)) {
            key = key + "_" + processUsage;
        } else {
            processUsage = null;
        }
        if (this.mapParameterSets.containsKey(key)) {
            parameterSet = this.mapParameterSets.get(key);
        } else {
            parameterSet = this.xJdfNodeFactory.createParameterSet();
            parameterSet.setName(paramName);
            parameterSet.setProcessUsage(processUsage);
            this.getXJdf().getSetType().add(this.xJdfNodeFactory.createParameterSet(parameterSet));
            this.mapParameterSets.put(key, parameterSet);
            Collections.sort(this.getXJdf().getSetType(), new SetTypeComparator());
        }
        parameterSet.getParameter().add(parameter);
    }
}

