/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class DateTime
extends AbstractXJdfType<String, DateTime> {
    private static final String PATTERN_UTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String PATTERN_GLOBAL = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final Calendar calendar;

    public DateTime() {
        this.calendar = Calendar.getInstance();
    }

    public DateTime(int year, int month, int day) {
        this(year, month, day, 23, 59);
    }

    public DateTime(int year, int month, int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, 0);
        this.calendar = cal;
    }

    public DateTime(Calendar calendar) {
        this.calendar = calendar;
    }

    public DateTime(String expression) throws ParseException {
        if (expression.endsWith(":00")) {
            expression = expression.substring(0, expression.length() - 3) + "00";
        } else if (expression.endsWith("Z")) {
            expression = expression.replaceFirst("Z", "+0000");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_GLOBAL);
        dateFormat.parse(expression);
        this.calendar = dateFormat.getCalendar();
        String[] ids = TimeZone.getAvailableIDs(this.calendar.get(15));
        this.calendar.setTimeZone(TimeZone.getTimeZone(ids[0]));
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String marshal(DateTime dateTime) {
        String result;
        if (dateTime == null) {
            return null;
        }
        TimeZone timeZone = dateTime.getCalendar().getTimeZone();
        if (timeZone.getRawOffset() == 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_UTC);
            dateFormat.setTimeZone(timeZone);
            result = dateFormat.format(dateTime.getCalendar().getTime());
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_GLOBAL);
            dateFormat.setTimeZone(timeZone);
            result = dateFormat.format(dateTime.getCalendar().getTime());
            result = result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
        }
        return result;
    }

    public DateTime unmarshal(String dateTime) throws Exception {
        return new DateTime(dateTime);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

