/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.internal.XmlNavigator;

public class XJdfNavigator
extends XmlNavigator {
    public static final String JOB_ID = "/XJDF/@JobID";
    public static final String CATEGORY = "/XJDF/@Category";
    public static final String GENERAL_CATALOG_ID = "/XJDF/GeneralID[@IDUsage='CatalogID']/@IDValue";
    public static final String GENERAL_LINE_ID = "/XJDF/GeneralID[@IDUsage='LineID']/@IDValue";
    public static final String FILE_SPEC_URL = "/XJDF/ParameterSet[@Name='RunList']/Parameter/RunList/FileSpec/@URL";
    public static final String MIN_APPROVALS = "/XJDF/ParameterSet[@Name='ApprovalParams']/Parameter/ApprovalParams/@MinApprovals";
    public static final String CUSTOMER_ID = "/XJDF/ParameterSet[@Name='CustomerInfo']/Parameter/CustomerInfo/@CustomerID";
    public static final String AMOUNT = "/XJDF/ProductList/Product/@Amount";
    public static final String MEDIA_QUALITY = "/XJDF/ProductList/Product/Intent[@Name='MediaIntent']/MediaIntent/@MediaQuality";
    public static final String LAYOUT_FINISHED_DIMENSIONS = "/XJDF/ProductList/Product/Intent[@Name='LayoutIntent']/LayoutIntent/@FinishedDimensions";
    public static final String LAYOUT_DIMENSIONS = "/XJDF/ProductList/Product/Intent[@Name='LayoutIntent']/LayoutIntent/@Dimensions";
    public static final String PRODUCTION_PRINT_PROCESS = "/XJDF/ProductList/Product/Intent[@Name='ProductionIntent']/ProductionIntent/@PrintProcess";
    public static final String FOLDING_CATALOG = "/XJDF/ProductList/Product/Intent[@Name='FoldingIntent']/FoldingIntent/@FoldingCatalog";
    public static final String COLOR_NUM_COLORS = "/XJDF/ProductList/Product/Intent[@Name='ColorIntent']/ColorIntent/@NumColors";

    public XJdfNavigator(InputStream xJdfStream) throws Exception {
        this(xJdfStream, false);
    }

    public XJdfNavigator(InputStream xJdfStream, boolean namespaceAware) throws Exception {
        super(xJdfStream, namespaceAware);
        this.addNamespace("xjdf", XJdfConstants.NAMESPACE_JDF20);
    }

    public XJdfNavigator(String xjdfPath) throws Exception {
        this(new FileInputStream(xjdfPath));
    }

    public XJdfNavigator(String xjdfPath, boolean namespaceAware) throws Exception {
        this(new FileInputStream(xjdfPath), namespaceAware);
    }

    public XJdfNavigator(File xjdfFile) throws Exception {
        this(new FileInputStream(xjdfFile));
    }

    public XJdfNavigator(File xjdfFile, boolean namespaceAware) throws Exception {
        this(new FileInputStream(xjdfFile), namespaceAware);
    }

    public XJdfNavigator(byte[] xJdfBytes) throws Exception {
        this(new ByteArrayInputStream(xJdfBytes));
    }

    public XJdfNavigator(byte[] xJdfBytes, boolean namespaceAware) throws Exception {
        this(new ByteArrayInputStream(xJdfBytes), namespaceAware);
    }

    public Object extractNode(String xPath) throws XPathExpressionException, JAXBException {
        return super.extractNode(xPath, new XJdfParser());
    }

    public void replaceNode(String xPath, Object replacement) throws XPathExpressionException, JAXBException, ParserConfigurationException {
        super.replaceNode(xPath, replacement, new XJdfParser());
    }
}

