/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;
import org.cip4.lib.xjdf.xml.XJdfNavigator;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlPackager;

public class XJdfPackager
extends AbstractXmlPackager {
    public XJdfPackager(String xjdfPath) throws Exception {
        super(xjdfPath);
    }

    public XJdfPackager(byte[] xjdf) throws Exception {
        this(xjdf, null);
    }

    public XJdfPackager(byte[] xjdf, String rootPath) throws Exception {
        super(xjdf, rootPath);
    }

    public void packageXJdf(OutputStream os) throws Exception {
        XJdfNavigator nav = new XJdfNavigator(this.getXmlDoc());
        String jobId = nav.readAttribute("/XJDF/@JobID");
        if (jobId != null) {
            jobId = jobId + ".xjdf";
        }
        this.packageXJdf(os, jobId);
    }

    public void packageXJdf(OutputStream os, String docName) throws Exception {
        this.packageXJdf(os, docName, false);
    }

    public void packageXJdf(OutputStream os, String docName, boolean withoutHierarchy) throws Exception {
        if (withoutHierarchy) {
            this.registerFiles("//FileSpec/@URL", "");
            this.registerFiles("//Preview/@URL", "");
            this.registerFiles("//XJDF/@CommentURL", "");
        } else {
            this.registerFiles("//FileSpec/@URL", "artwork");
            this.registerFiles("//Preview/@URL", "preview");
            this.registerFiles("//XJDF/@CommentURL", "docs");
        }
        if (docName == null || docName.equals("")) {
            docName = IDGeneratorUtil.generateID("XJDF") + ".xjdf";
        } else if (StringUtils.isEmpty((String)FilenameUtils.getExtension((String)docName))) {
            docName = docName + ".ptk";
        }
        this.packageXml(os, docName);
    }
}

