/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.xml.internal.PackagerException;
import org.cip4.lib.xjdf.xml.internal.XmlNavigator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlPackager {
    private CompressionLevel compressionLevel;
    private final URI rootUri;
    private final Map<File, URI> fileMap;
    private final XmlNavigator xPathNav;
    private final byte[] xmlDoc;

    public AbstractXmlPackager(String xmlPath) throws Exception {
        FileInputStream is = new FileInputStream(xmlPath);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        ((InputStream)is).close();
        String rootPath = FilenameUtils.getFullPath((String)xmlPath);
        this.xPathNav = new XmlNavigator(bytes);
        this.compressionLevel = CompressionLevel.DEFAULT_COMPRESSION;
        this.fileMap = new HashMap<File, URI>();
        this.xmlDoc = bytes;
        this.rootUri = new File(rootPath).toURI();
    }

    public AbstractXmlPackager(byte[] xmlDoc, String rootPath) throws Exception {
        this.xPathNav = new XmlNavigator(xmlDoc);
        this.compressionLevel = CompressionLevel.DEFAULT_COMPRESSION;
        this.fileMap = new HashMap<File, URI>();
        this.xmlDoc = xmlDoc;
        this.rootUri = null != rootPath ? new File(rootPath).toURI() : null;
    }

    protected byte[] getXmlDoc() {
        return this.xmlDoc;
    }

    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(CompressionLevel compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    protected void packageXml(OutputStream os, String docName) throws Exception {
        ZipOutputStream zout = new ZipOutputStream(os);
        zout.setLevel(this.compressionLevel.getLevel());
        ZipEntry zipEntryXml = new ZipEntry(docName);
        zout.putNextEntry(zipEntryXml);
        InputStream isXJdf = this.xPathNav.getXmlStream();
        IOUtils.copy((InputStream)isXJdf, (OutputStream)zout);
        isXJdf.close();
        for (File key : this.fileMap.keySet()) {
            InputStream fis = this.fileMap.get(key).toURL().openStream();
            ZipEntry zipEntryFile = new ZipEntry(key.getPath());
            zout.putNextEntry(zipEntryFile);
            IOUtils.copy((InputStream)fis, (OutputStream)zout);
            fis.close();
        }
        zout.finish();
    }

    protected void registerFiles(String xPathAttribute, String targetDir) throws PackagerException {
        NodeList nodeList;
        try {
            nodeList = this.xPathNav.evaluateNodeList(xPathAttribute);
        }
        catch (XPathExpressionException e) {
            throw new PackagerException("NodeList could not be retrieved from xJdf.", e);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String filePath = node.getTextContent();
            File targetFile = this.registerFile(filePath, targetDir);
            node.setNodeValue(FilenameUtils.separatorsToUnix((String)targetFile.getPath()));
        }
    }

    protected File registerFile(String srcPath, String targetDir) throws PackagerException {
        URI srcUri;
        try {
            srcUri = new URI(srcPath);
        }
        catch (URISyntaxException e) {
            srcUri = null;
        }
        if (srcUri == null || !srcUri.isAbsolute()) {
            File file = new File(srcPath);
            if (!file.isAbsolute()) {
                if (this.rootUri == null) {
                    throw new PackagerException(String.format("Can not resolve relative path '%s' because no rootPath was provided.", srcPath));
                }
                file = new File(this.rootUri.resolve(FilenameUtils.separatorsToUnix((String)file.getPath())));
            }
            srcUri = file.toURI();
        }
        File targetFile = new File(FilenameUtils.concat((String)targetDir, (String)FilenameUtils.getName((String)srcUri.getPath())));
        this.fileMap.put(targetFile, srcUri);
        return targetFile;
    }

    public static enum CompressionLevel {
        BEST_SPEED(1),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1),
        NO_COMPRESSION(0);

        private final int level;

        private CompressionLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

