/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.XmlStreamWriter;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlValidator;
import org.cip4.lib.xjdf.xml.internal.XJdfNamespaceMapper;
import org.w3c.dom.Node;

public abstract class AbstractXmlParser<T> {
    private final JAXBContext jaxbContext;

    protected AbstractXmlParser(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    protected Object parseNode(Node w3cNode) throws JAXBException {
        Unmarshaller u = this.jaxbContext.createUnmarshaller();
        Object dom = u.unmarshal(w3cNode);
        return dom;
    }

    protected void parseNode(Object xmlNode, Node w3cNode) throws JAXBException {
        Marshaller m = this.createMarshaller();
        m.marshal(xmlNode, w3cNode);
    }

    protected byte[] parseXml(T obj, Class abstractValidatorClass) throws Exception {
        return this.parseXml(obj, false, abstractValidatorClass);
    }

    protected void parseXml(T obj, OutputStream os, Class abstractValidatorClass) throws Exception {
        this.parseXml(obj, os, false, abstractValidatorClass);
    }

    protected byte[] parseXml(T obj, boolean skipValidation, Class abstractValidatorClass) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.parseXml(obj, bos, skipValidation, abstractValidatorClass);
        bos.close();
        return bos.toByteArray();
    }

    protected void parseXml(T obj, OutputStream os, boolean skipValidation, Class abstractValidatorClass) throws Exception {
        ByteArrayInputStream is;
        Marshaller m = this.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.setProperty("com.sun.xml.bind.xmlHeaders", (Object)this.getXmlHeader());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XmlStreamWriter xmlWriter = new XmlStreamWriter((OutputStream)bos, "UTF-8");
        m.marshal(obj, (Writer)xmlWriter);
        byte[] doc = bos.toByteArray();
        if (!skipValidation) {
            is = new ByteArrayInputStream(doc);
            Constructor ctor = abstractValidatorClass.getDeclaredConstructor(InputStream.class);
            AbstractXmlValidator validator = (AbstractXmlValidator)ctor.newInstance(is);
            if (!validator.isValid()) {
                String err = validator.getMessagesText();
                throw new ValidationException(err);
            }
        }
        is = new ByteArrayInputStream(doc);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        ((InputStream)is).close();
    }

    protected T parseBytes(byte[] bytes) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return this.parseStream(is);
    }

    protected T parseStream(InputStream is) throws Exception {
        Unmarshaller u = this.jaxbContext.createUnmarshaller();
        Object dom = u.unmarshal(is);
        return (T)dom;
    }

    protected NamespacePrefixMapper getNamespacePrefixMapper() {
        return new XJdfNamespaceMapper();
    }

    protected String getXmlHeader() {
        String header = "";
        header = header + "<!-- Generated by CIP4 xJdfLib " + XJdfConstants.XJDF_LIB_VERSION + " -->\r\n";
        header = header.replaceAll("  ", " ");
        return header;
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller m = this.jaxbContext.createMarshaller();
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)this.getNamespacePrefixMapper());
        return m;
    }
}

