/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import java.util.List;
import java.util.ListIterator;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.comparator.SetTypeComparator;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.SetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Assets<S extends SetType, T, U> {
    private final List<? extends SetType> assetSets;
    private final SetTypeComparator setTypeComparator = new SetTypeComparator();
    private final XJdfNodeFactory nodeFactory = new XJdfNodeFactory();

    public Assets(@NotNull List<? extends SetType> assetSets) {
        this.assetSets = assetSets;
    }

    public final void addAsset(@NotNull T asset, @Nullable String processUsage) {
        String assetName = this.getAssetName(asset);
        S assetSet = this.findAssetSet(assetName, processUsage);
        if (null == assetSet) {
            assetSet = this.createSet();
            ((SetType)assetSet).withName(assetName).withProcessUsage(processUsage);
            this.addAssetSet(assetSet);
        }
        this.addAssets(assetSet, asset);
    }

    public final <V extends U> void addAsset(@NotNull V assetType, @Nullable Part part, @Nullable String processUsage) {
        this.addAsset(this.createAsset(assetType, part), processUsage);
    }

    @NotNull
    abstract <V extends U> T createAsset(@NotNull V var1, @Nullable Part var2);

    abstract String getAssetName(@NotNull T var1);

    @NotNull
    abstract S createSet();

    abstract void addAssets(@NotNull S var1, @NotNull T var2);

    @Nullable
    final S findAssetSet(@NotNull String assetName, @Nullable String processUsage) {
        for (SetType setType : this.assetSets) {
            if (!setType.getName().equals(assetName) || (processUsage != null || setType.getProcessUsage() != null) && (processUsage == null || !processUsage.equals(setType.getProcessUsage()))) continue;
            return (S)setType;
        }
        return null;
    }

    public final void addAssetSet(S assetSet) {
        ListIterator<? extends SetType> listIterator = this.assetSets.listIterator();
        while (listIterator.hasNext()) {
            SetType currentSet = listIterator.next();
            if (this.setTypeComparator.compare(currentSet, (SetType)assetSet) <= 0) continue;
            if (!listIterator.hasPrevious()) break;
            listIterator.previous();
            break;
        }
        listIterator.add((SetType)assetSet);
    }

    @NotNull
    protected final XJdfNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }
}

