/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.uri.resolver.URIResolver;
import org.cip4.lib.xjdf.xml.XJdfNavigator;
import org.cip4.lib.xjdf.xml.internal.PackagerException;
import org.cip4.lib.xjdf.xml.internal.XmlNavigator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlPackager {
    private static final Collection<String> SCHEME_BLACKLIST = Arrays.asList("http", "https");
    private final ZipOutputStream zout;
    private final boolean withoutHierarchy;

    public AbstractXmlPackager(OutputStream out) {
        this(out, false);
    }

    public AbstractXmlPackager(OutputStream out, boolean withoutHierarchy) {
        this.zout = new ZipOutputStream(out);
        this.withoutHierarchy = withoutHierarchy;
    }

    public final void setCompressionLevel(CompressionLevel compressionLevel) {
        this.zout.setLevel(compressionLevel.level);
    }

    public abstract void packageXml(XmlNavigator var1, URI var2) throws PackagerException, XPathExpressionException;

    protected final void packageXml(XmlNavigator xmlNavigator, String docName, URI rootUri) throws PackagerException {
        try {
            PreparedPackagingData packagingData = this.prepareForPackaging(xmlNavigator, rootUri);
            this.writeZipEntry(new ZipEntry(docName), packagingData.nav.getXmlStream());
            for (Map.Entry<String, String> entry : packagingData.fileRefs.entrySet()) {
                URI uri = URIResolver.resolve(rootUri, entry.getKey());
                String targetPath = entry.getValue();
                InputStream is = uri.toURL().openStream();
                Throwable throwable = null;
                try {
                    this.writeZipEntry(new ZipEntry(targetPath), is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            this.zout.finish();
        }
        catch (Exception e) {
            throw new PackagerException("Error while packaging XML document.", e);
        }
    }

    private String encodeURIBaseName(String path) throws URISyntaxException {
        String baseName = path.substring(path.lastIndexOf(47) + 1);
        String parsedBaseName = new URI(baseName).getPath();
        return this.encodeURIPath(parsedBaseName.replaceAll("[^-_a-zA-Z0-9.]+", "_"));
    }

    private String encodeURIPath(String path) throws URISyntaxException {
        return new URI(null, null, path, null).toASCIIString();
    }

    final PreparedPackagingData prepareForPackaging(XmlNavigator nav, URI rootUri) throws URISyntaxException, Exception {
        XJdfNavigator xJdfNavigator = new XJdfNavigator(nav.getXmlBytes(), true);
        return new PreparedPackagingData(xJdfNavigator, this.relativizeNodeList(xJdfNavigator.evaluateNodeList("//xjdf:Preview/@URL"), rootUri, "preview/"), this.relativizeNodeList(xJdfNavigator.evaluateNodeList("//xjdf:FileSpec/@URL"), rootUri, "artwork/"), this.relativizeNodeList(xJdfNavigator.evaluateNodeList("//xjdf:XJDF/@CommentURL"), rootUri, "docs/"));
    }

    private Map<String, String> relativizeNodeList(NodeList nodeList, URI rootUri, String targetDir) throws URISyntaxException {
        HashMap<String, String> referencedFiles = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String uriString = node.getNodeValue();
            if (!this.shouldIncludeFileReference(URIResolver.resolve(rootUri, uriString))) continue;
            String baseName = this.encodeURIBaseName(uriString);
            String uriFileName = this.withoutHierarchy ? baseName : targetDir + baseName;
            node.setNodeValue(uriFileName);
            referencedFiles.put(uriString, uriFileName);
        }
        return referencedFiles;
    }

    private boolean shouldIncludeFileReference(URI uri) {
        return !SCHEME_BLACKLIST.contains(uri.getScheme().toLowerCase());
    }

    private void writeZipEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException {
        this.zout.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.zout);
    }

    public static enum CompressionLevel {
        BEST_SPEED(1),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1),
        NO_COMPRESSION(0);

        private final int level;

        private CompressionLevel(int level) {
            this.level = level;
        }
    }

    final class PreparedPackagingData {
        final XmlNavigator nav;
        final Map<String, String> fileRefs = new HashMap<String, String>();

        PreparedPackagingData(XJdfNavigator xJdfNavigator, Map<String, String> ... fileRefs) {
            this.nav = xJdfNavigator;
            for (Map<String, String> fileRefMap : fileRefs) {
                for (Map.Entry<String, String> entry : fileRefMap.entrySet()) {
                    this.fileRefs.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

