/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractXmlUnpackager {
    private final String pathPackage;
    private final List<String> lstFilename;

    public AbstractXmlUnpackager(String pathPackage) throws IOException {
        this.pathPackage = pathPackage;
        this.lstFilename = new ArrayList<String>();
        try (FileInputStream fileInputStream = new FileInputStream(pathPackage);
             ZipInputStream packageStream = new ZipInputStream(fileInputStream);){
            ZipEntry entry = packageStream.getNextEntry();
            while (entry != null) {
                this.lstFilename.add(entry.getName());
                entry = packageStream.getNextEntry();
            }
        }
    }

    protected String unpackageZipTemp() throws IOException {
        return this.unpackageZipTemp("cip4");
    }

    protected String unpackageZipTemp(String appName) throws IOException {
        String tempDir = FileUtils.getTempDirectoryPath();
        String rootName = String.format("%s_unpackage_%s", appName, System.currentTimeMillis());
        String targetDir = FilenameUtils.concat((String)tempDir, (String)rootName);
        return this.unpackageZip(targetDir);
    }

    protected String unpackageZip(String targetDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.pathPackage));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String targetPath = FilenameUtils.concat((String)targetDir, (String)entry.getName());
                File targetFile = new File(targetPath);
                File td = new File(FilenameUtils.getFullPath((String)targetPath));
                td.mkdirs();
                if (!entry.isDirectory()) {
                    try (FileOutputStream fos = new FileOutputStream(targetFile);){
                        IOUtils.copy((InputStream)zis, (OutputStream)fos);
                    }
                }
                entry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        String relativePath = this.findMasterDocumentPath();
        relativePath = FilenameUtils.normalize((String)relativePath);
        targetDir = FilenameUtils.normalize((String)targetDir);
        return FilenameUtils.concat((String)targetDir, (String)relativePath);
    }

    protected String findMasterDocumentPath() throws IOException {
        String masterPath = null;
        for (int i = 0; i < this.lstFilename.size() && masterPath == null; ++i) {
            String p = this.lstFilename.get(i);
            for (int n = 0; n < this.getMasterExtension().length && masterPath == null; ++n) {
                if (!FilenameUtils.getExtension((String)p).equals(this.getMasterExtension()[n])) continue;
                masterPath = p;
            }
        }
        return masterPath;
    }

    protected byte[] findMasterDocument() throws IOException {
        byte[] bytes = null;
        String masterPath = this.findMasterDocumentPath();
        if (!StringUtils.isEmpty((String)masterPath)) {
            bytes = this.extractFile(masterPath);
        }
        return bytes;
    }

    public byte[] extractFile(String relativePath) throws IOException {
        String searchPath = FilenameUtils.normalize((String)relativePath, (boolean)true);
        byte[] bytes = null;
        try (FileInputStream fileStream = new FileInputStream(this.pathPackage);
             ZipInputStream packageStream = new ZipInputStream(fileStream);){
            ZipEntry entry = packageStream.getNextEntry();
            while (entry != null && bytes == null) {
                if (entry.getName().equals(searchPath)) {
                    bytes = IOUtils.toByteArray((InputStream)packageStream);
                }
                entry = packageStream.getNextEntry();
            }
        }
        return bytes;
    }

    protected abstract String[] getMasterExtension();
}

