/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.ChildProduct;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.IntentType;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.w3c.dom.Node;

public class ProductBuilder
extends AbstractNodeBuilder<Product> {
    private static final String ID_PREFIX = "PRD";
    private final XJdfNodeFactory xJdfNodeFactory = new XJdfNodeFactory();

    public ProductBuilder() {
        this(null, null, null, null);
    }

    public ProductBuilder(Node productNode) throws JAXBException {
        super(productNode, Product.class);
    }

    public ProductBuilder(Integer amount) {
        this(amount, null, null, null);
    }

    public ProductBuilder(Integer amount, String productType, String productTypeDetails) {
        this(amount, productType, productTypeDetails, null);
    }

    public ProductBuilder(Integer amount, String productType, String productTypeDetails, String descriptiveName) {
        super(new XJdfNodeFactory().createProduct());
        this.getProduct().setAmount(amount);
        this.getProduct().setProductType(productType);
        this.getProduct().setProductTypeDetails(productTypeDetails);
        this.getProduct().setDescriptiveName(descriptiveName);
    }

    public ProductBuilder(Product product) {
        super(product);
    }

    protected Product getProduct() {
        return (Product)this.getNode();
    }

    public void addIntent(IntentType intent) {
        if (intent == null) {
            return;
        }
        String intentName = intent.getClass().getSimpleName();
        Intent it = this.xJdfNodeFactory.createIntent();
        it.setName(intentName);
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, intentName);
        JAXBElement obj = new JAXBElement(qname, intent.getClass(), (Object)intent);
        it.setIntentType((JAXBElement<? extends IntentType>)obj);
        this.getProduct().getIntent().add(it);
    }

    public final void addChildProduct(Product childRef) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)childRef.getID())) {
            throw new IllegalArgumentException("'ID' must not be null or blank.");
        }
        ChildProduct childProduct = this.xJdfNodeFactory.createChildProduct();
        childProduct.setChildRef(childRef);
        this.getProduct().getChildProduct().add(childProduct);
        this.getProduct().setIsRoot(true);
    }
}

