/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.comparator.SetTypeComparator;
import org.cip4.lib.xjdf.schema.Audit;
import org.cip4.lib.xjdf.schema.AuditPool;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Parameter;
import org.cip4.lib.xjdf.schema.ParameterSet;
import org.cip4.lib.xjdf.schema.ParameterType;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.ResourceType;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;
import org.cip4.lib.xjdf.util.Parameters;
import org.cip4.lib.xjdf.util.Resources;
import org.cip4.lib.xjdf.util.SetTypeWrapper;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class XJdfBuilder
extends AbstractNodeBuilder<XJDF> {
    private final XJdfNodeFactory xJdfNodeFactory;
    private final Parameters parameterSets;
    private final Resources resourceSets;

    public XJdfBuilder() {
        this(null, null, null, null);
    }

    public XJdfBuilder(String jobID) {
        this(jobID, null, null, null);
    }

    public XJdfBuilder(String jobID, String category) {
        this(jobID, category, null, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName) {
        this(jobID, category, descriptiveName, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName, String relatedJobID) {
        super(new XJdfNodeFactory().createXJDF());
        SetTypeWrapper setTypeWrapper = new SetTypeWrapper(((XJDF)this.getNode()).getSetType());
        this.parameterSets = new Parameters(setTypeWrapper);
        this.resourceSets = new Resources(setTypeWrapper);
        this.xJdfNodeFactory = new XJdfNodeFactory();
        this.getXJdf().setJobID(jobID);
        this.getXJdf().setCategory(category);
        this.getXJdf().setDescriptiveName(descriptiveName);
        this.getXJdf().setRelatedJobID(relatedJobID);
        this.getXJdf().setVersion("2.0");
        this.getXJdf().setID(IDGeneratorUtil.generateID("XJDF"));
    }

    public XJdfBuilder(XJDF xjdf) {
        super(xjdf);
        SetTypeWrapper setTypeWrapper = new SetTypeWrapper(((XJDF)this.getNode()).getSetType());
        this.parameterSets = new Parameters(setTypeWrapper);
        this.resourceSets = new Resources(setTypeWrapper);
        this.xJdfNodeFactory = new XJdfNodeFactory();
        Collections.sort(setTypeWrapper, new SetTypeComparator());
    }

    public XJDF getXJdf() {
        return (XJDF)this.getNode();
    }

    public final void addComment(String comment) {
        Comment obj = this.xJdfNodeFactory.createComment(comment);
        ((XJDF)this.getNode()).getComment().add(obj);
    }

    public final void addAudit(Audit audit) {
        if (audit == null) {
            return;
        }
        String paramName = audit.getClass().getSimpleName();
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
        JAXBElement obj = new JAXBElement(qname, audit.getClass(), null, (Object)audit);
        if (this.getXJdf().getAuditPool() == null) {
            AuditPool auditPool = this.xJdfNodeFactory.createAuditPool();
            this.getXJdf().setAuditPool(auditPool);
        }
        this.getXJdf().getAuditPool().getAudit().add((JAXBElement<? extends Audit>)obj);
    }

    public final void addGeneralID(GeneralID generalId) {
        if (generalId == null) {
            return;
        }
        this.getXJdf().getGeneralID().add(generalId);
    }

    public final void addProduct(Product product) {
        if (product == null) {
            return;
        }
        if (this.getXJdf().getProductList() == null) {
            this.getXJdf().setProductList(this.xJdfNodeFactory.createProductList());
        }
        this.getXJdf().getProductList().getProduct().add(product);
    }

    public final void addParameter(ParameterType parameterType) {
        this.addParameter(parameterType, null, null);
    }

    public final void addParameter(ParameterType parameterType, String processUsage) {
        this.addParameter(parameterType, null, processUsage);
    }

    public final void addParameter(List<ParameterType> parameterTypes) {
        this.addParameter(parameterTypes, null);
    }

    public final void addParameter(List<ParameterType> parameterTypes, String processUsage) {
        for (ParameterType parameter : parameterTypes) {
            this.addParameter(parameter, null, processUsage);
        }
    }

    public final void addParameter(ParameterType parameterType, Part part) {
        this.addParameter(parameterType, part, null);
    }

    public void addParameter(ParameterType parameterType, Part part, String processUsage) {
        if (parameterType == null) {
            return;
        }
        Parameter parameter = this.xJdfNodeFactory.createParameter(parameterType, part);
        this.addParameter(parameter, processUsage);
    }

    public void addParameter(Parameter parameter) {
        this.addParameter(parameter, null);
    }

    public final void addParameter(Parameter parameter, String processUsage) {
        this.parameterSets.addAsset(parameter, processUsage);
    }

    public final void addParameterSet(ParameterSet parameterSet) {
        this.parameterSets.addAssetSet(parameterSet);
    }

    public final Resource addResource(ResourceType resourceType, Part part) {
        return this.addResource(resourceType, part, null);
    }

    public final Resource addResource(ResourceType resourceType, Part part, String processUsage) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Resource may not be null.");
        }
        Resource resource = this.xJdfNodeFactory.createResource(resourceType, part);
        resource.setID(resource.getResourceType().getName().getLocalPart() + "_" + UUID.randomUUID().toString());
        this.addResource(resource, processUsage);
        return resource;
    }

    public void addResource(Resource resource, String processUsage) {
        this.resourceSets.addAsset(resource, processUsage);
    }

    public final void addResourceSet(ResourceSet resourceSet) {
        this.resourceSets.addAssetSet(resourceSet);
    }
}

