/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.merger;

import java.util.ArrayList;
import java.util.Collection;
import org.cip4.lib.xjdf.merger.BaseMerger;
import org.cip4.lib.xjdf.merger.CombinedMerger;
import org.cip4.lib.xjdf.merger.JAXBElementMerger;
import org.cip4.lib.xjdf.merger.MergeConflictException;
import org.cip4.lib.xjdf.merger.ParameterSetMerger;
import org.cip4.lib.xjdf.merger.ProductListMerger;
import org.cip4.lib.xjdf.merger.ProductMerger;
import org.cip4.lib.xjdf.merger.ResourceSetMerger;
import org.cip4.lib.xjdf.schema.ProductList;
import org.cip4.lib.xjdf.schema.SetType;
import org.cip4.lib.xjdf.schema.XJDF;

public class XjdfMerger
extends BaseMerger<XJDF> {
    private final BaseMerger<ProductList> productListMerger;
    private final JAXBElementMerger<? extends SetType> assetSetMerger;

    XjdfMerger(BaseMerger<ProductList> productListMerger, JAXBElementMerger<? extends SetType> assetSetMerger) {
        this.productListMerger = productListMerger;
        this.assetSetMerger = assetSetMerger;
    }

    public XjdfMerger() {
        this.productListMerger = new ProductListMerger(new ProductMerger());
        ArrayList assetSetMergers = new ArrayList(2);
        assetSetMergers.add(new ParameterSetMerger());
        assetSetMergers.add(new ResourceSetMerger());
        CombinedMerger internalAssetSetMerger = new CombinedMerger(assetSetMergers);
        this.assetSetMerger = new JAXBElementMerger<SetType>(internalAssetSetMerger);
    }

    public final XJDF merge(XJDF ... xjdfs) throws MergeConflictException {
        XJDF resultingXjdf = new XJDF();
        for (XJDF xjdf : xjdfs) {
            this.merge(resultingXjdf, xjdf);
        }
        return resultingXjdf;
    }

    @Override
    final void merge(XJDF baseObject, XJDF mergeObject) throws MergeConflictException {
        if (null != mergeObject.getProductList()) {
            if (null == baseObject.getProductList()) {
                baseObject.setProductList(mergeObject.getProductList());
            } else {
                this.productListMerger.merge(baseObject.getProductList(), mergeObject.getProductList());
            }
        }
        baseObject.getGeneralID().addAll(mergeObject.getGeneralID());
        this.assetSetMerger.merge((Collection<? extends SetType>)baseObject.getSetType(), (SetType)((Object)mergeObject.getSetType()));
    }
}

