/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import javax.xml.bind.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.schema.Parameter;
import org.cip4.lib.xjdf.schema.ParameterType;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.type.AbstractXJdfType;
import org.cip4.lib.xjdf.util.IDGeneratorUtil;

public class IDREF
extends AbstractXJdfType<String, IDREF> {
    private final String id;
    private final Object element;

    public IDREF() {
        this.id = "";
        this.element = null;
    }

    public String getId() {
        return this.id;
    }

    public Parameter getParameter() {
        return (Parameter)this.element;
    }

    public Product getProduct() {
        return (Product)this.element;
    }

    public IDREF(ParameterType parameterType) {
        this(parameterType, null, IDGeneratorUtil.generateID("PAR"));
    }

    public IDREF(ParameterType parameterType, Part part, String id) {
        this.id = id;
        XJdfNodeFactory nf = new XJdfNodeFactory();
        Parameter parameter = nf.createParameter(parameterType, part);
        parameter.setID(this.id);
        this.element = parameter;
    }

    public IDREF(Product product) throws ValidationException {
        this(product, IDREF.generateId(product));
    }

    public IDREF(Product product, String id) throws ValidationException {
        this.id = id;
        product.setID(id);
        if (product.getChildProduct().size() > 0) {
            throw new ValidationException("A Child Product cannot have children!");
        }
        this.element = product;
    }

    public IDREF(String expression) {
        this.id = expression;
        this.element = null;
    }

    public String marshal(IDREF idRef) {
        if (idRef == null) {
            return null;
        }
        return idRef.getId();
    }

    public IDREF unmarshal(String v) {
        return new IDREF(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }

    private static String generateId(Product product) {
        String productId = product.getID();
        if (StringUtils.isEmpty((CharSequence)productId)) {
            productId = IDGeneratorUtil.generateID("PRD");
        }
        return productId;
    }
}

