/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.Preview;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.type.URI;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.internal.JAXBNavigator;
import org.cip4.lib.xjdf.xml.internal.PackagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlPackager<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractXmlPackager.class);
    private Path zipPath;
    private final ZipOutputStream zout;

    public AbstractXmlPackager(OutputStream out) {
        this(null, out);
    }

    public AbstractXmlPackager(Path zipPath, OutputStream out) {
        this.zipPath = zipPath;
        this.zout = new ZipOutputStream(out);
    }

    public final AbstractXmlPackager<T> withZipPath(Path zipPath) {
        this.zipPath = zipPath;
        return this;
    }

    public final void setCompressionLevel(CompressionLevel compressionLevel) {
        this.zout.setLevel(compressionLevel.level);
    }

    protected final void packageXml(T document, String docName) throws PackagerException {
        try {
            JAXBNavigator<T> jaxbNavigator = new JAXBNavigator<T>(document);
            jaxbNavigator.addNamespace("xjdf", XJdfConstants.NAMESPACE_JDF20);
            jaxbNavigator.addNamespace("ptk", XJdfConstants.NAMESPACE_JDF20);
            LinkedList<URI> assetReferences = new LinkedList<URI>();
            assetReferences.addAll(this.collectReferences(new URIExtractor<Preview>(){

                @Override
                public URI extract(Preview preview) {
                    return preview.getURL();
                }
            }, jaxbNavigator.evaluateNodeList("//xjdf:Preview")));
            assetReferences.addAll(this.collectReferences(new URIExtractor<FileSpec>(){

                @Override
                public URI extract(FileSpec fileSpec) {
                    return fileSpec.getURL();
                }
            }, jaxbNavigator.evaluateNodeList("//xjdf:FileSpec")));
            assetReferences.addAll(this.collectReferences(new URIExtractor<XJDF>(){

                @Override
                public URI extract(XJDF xjdf) {
                    return xjdf.getCommentURL();
                }
            }, new Object[]{document instanceof XJDF ? document : jaxbNavigator.evaluateNode("//xjdf:XJDF")}));
            this.writeZipEntry(new ZipEntry(docName), new ByteArrayInputStream(this.parseDocument(document)));
            try (FileSystem zipfs = this.zipPath != null ? FileSystems.newFileSystem(this.zipPath, null) : null;){
                for (URI uri : assetReferences) {
                    Throwable throwable;
                    InputStream is;
                    LOGGER.debug(String.format("Start processing uri '%s'.", new Object[]{uri}));
                    String destPath = uri.getDestinationPath();
                    if (destPath == null) continue;
                    java.net.URI srcUri = uri.getSourceUri();
                    if (!srcUri.isAbsolute()) {
                        is = Files.newInputStream(zipfs.getPath("/", srcUri.getPath()), new OpenOption[0]);
                        throwable = null;
                        try {
                            this.writeZipEntry(new ZipEntry(destPath), is);
                            continue;
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            is.close();
                            continue;
                        }
                    }
                    is = srcUri.toURL().openStream();
                    throwable = null;
                    try {
                        this.writeZipEntry(new ZipEntry(destPath), is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            this.zout.finish();
        }
        catch (Exception e) {
            throw new PackagerException("Error while packaging XML document.", e);
        }
    }

    final Collection<URI> collectReferences(URIExtractor extractor, Object[] refs) {
        ArrayList<URI> result = new ArrayList<URI>();
        for (Object ref : refs) {
            URI uri = extractor.extract(ref);
            if (uri == null) continue;
            result.add(uri.complete());
        }
        return result;
    }

    private void writeZipEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException {
        this.zout.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.zout);
    }

    protected abstract byte[] parseDocument(T var1) throws Exception;

    public static enum CompressionLevel {
        BEST_SPEED(1),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1),
        NO_COMPRESSION(0);

        private final int level;

        private CompressionLevel(int level) {
            this.level = level;
        }
    }

    static interface URIExtractor<T> {
        public URI extract(T var1);
    }
}

