/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXmlValidator<T> {
    private final Map<String, byte[]> xsdDependencies;

    public AbstractXmlValidator(Map<String, byte[]> xsdDependencies) {
        this.xsdDependencies = xsdDependencies;
    }

    public final void validate(InputStream documentStream) throws ValidationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new ResourceResolver());
            Schema schema = schemaFactory.newSchema(this.getSchema());
            XJdfErrorHandler errorHandler = new XJdfErrorHandler();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setSchema(schema);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(errorHandler);
            db.parse(documentStream);
            List<String> messages = errorHandler.getMessages();
            if (messages.size() > 0) {
                throw new ValidationException("Validation of the document failed due to following error messages: " + System.lineSeparator() + StringUtils.join(messages, (String)System.lineSeparator()));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract URL getSchema();

    private class ResourceResolver
    implements LSResourceResolver {
        private ResourceResolver() {
        }

        @Override
        public final LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            DOMInputImpl lsInput = new DOMInputImpl(publicId, systemId, null);
            if (AbstractXmlValidator.this.xsdDependencies != null && AbstractXmlValidator.this.xsdDependencies.containsKey(systemId)) {
                lsInput.setByteStream(new ByteArrayInputStream((byte[])AbstractXmlValidator.this.xsdDependencies.get(systemId)));
                lsInput.setSystemId(systemId);
            }
            return lsInput;
        }
    }

    private class XJdfErrorHandler
    implements ErrorHandler {
        private final List<String> messages = new ArrayList<String>();

        private XJdfErrorHandler() {
        }

        public List<String> getMessages() {
            return this.messages;
        }

        @Override
        public void warning(SAXParseException exception) {
            String msg = "WARNING in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void error(SAXParseException exception) {
            String msg = "ERROR in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            String msg = "FATAL in XJDF Doc ERROR at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }
    }
}

