/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.output.XmlStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.type.AbstractXJdfType;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlParser;
import org.cip4.lib.xjdf.xml.internal.NamespaceManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlNavigator {
    protected final XPath xPath;
    protected final Document xmlDocument;
    protected final NamespaceManager nsManager = new NamespaceManager();

    public XmlNavigator(byte[] xmlBytes) throws ParserConfigurationException, SAXException, IOException {
        this(xmlBytes, false);
    }

    public XmlNavigator(byte[] xmlBytes, boolean namespaceAware) throws IOException, SAXException, ParserConfigurationException {
        this(new ByteArrayInputStream(xmlBytes), namespaceAware);
    }

    public XmlNavigator(InputStream xmlStream) throws IOException, SAXException, ParserConfigurationException {
        this(xmlStream, false);
    }

    public XmlNavigator(InputStream xmlStream, boolean namespaceAware) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(namespaceAware);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        try (InputStream inputStream = xmlStream;){
            this.xmlDocument = docBuilder.parse(new InputSource(inputStream));
        }
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xPath = xPathFactory.newXPath();
        this.xPath.setNamespaceContext(this.nsManager);
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public void addNamespace(String prefix, String uri) {
        this.nsManager.addNamespace(prefix, uri);
    }

    public String readAttribute(String xPath) throws XPathExpressionException {
        return (String)this.evaluate(xPath, XPathConstants.STRING);
    }

    public Object readAttribute(String xPath, Class xJdfType) throws XPathExpressionException, ReflectiveOperationException {
        String value = this.evaluateString(xPath);
        Constructor ctor = xJdfType.getDeclaredConstructor(String.class);
        AbstractXJdfType validator = (AbstractXJdfType)((Object)ctor.newInstance(value));
        return validator;
    }

    private Object evaluate(String xPath, QName qname) throws XPathExpressionException {
        Object result = this.xPath.evaluate(xPath, this.xmlDocument, qname);
        return result;
    }

    public double evaluateDouble(String xPath) throws XPathExpressionException {
        return (Double)this.evaluate(xPath, XPathConstants.NUMBER);
    }

    public Integer evaluateInt(String xPath) throws XPathExpressionException {
        String s = (String)this.evaluate(xPath, XPathConstants.STRING);
        Integer result = null;
        if (!StringUtils.isEmpty((CharSequence)s) && StringUtils.isNumeric((CharSequence)s)) {
            result = new Integer(s);
        }
        return result;
    }

    public Long evaluateLong(String xPath) throws XPathExpressionException {
        String s = (String)this.evaluate(xPath, XPathConstants.STRING);
        Long result = null;
        if (!StringUtils.isEmpty((CharSequence)s) && StringUtils.isNumeric((CharSequence)s)) {
            result = new Long(s);
        }
        return result;
    }

    public String evaluateString(String xPath) throws XPathExpressionException {
        return (String)this.evaluate(xPath, XPathConstants.STRING);
    }

    public Node evaluateNode(String xPath) throws XPathExpressionException {
        return (Node)this.evaluate(xPath, XPathConstants.NODE);
    }

    public NodeList evaluateNodeList(String xPath) throws XPathExpressionException {
        return (NodeList)this.evaluate(xPath, XPathConstants.NODESET);
    }

    public final <T extends AbstractXJdfType> T evaluate(String xPath, Class<T> xJdfType) throws XPathExpressionException, ReflectiveOperationException {
        String value = this.evaluateString(xPath);
        Constructor<T> ctor = xJdfType.getDeclaredConstructor(String.class);
        return (T)((Object)((AbstractXJdfType)((Object)xJdfType.cast(ctor.newInstance(value)))));
    }

    protected Object extractNode(String xPath, AbstractXmlParser parser) throws XPathExpressionException, JAXBException {
        Node node = this.evaluateNode(xPath);
        Object obj = parser.parseNode(node);
        return obj;
    }

    public void removeNode(String xPath) throws ParserConfigurationException, XPathExpressionException {
        Node node = (Node)this.evaluate(xPath, XPathConstants.NODE);
        Node parentNode = node.getParentNode();
        parentNode.removeChild(node);
    }

    protected void replaceNode(String xPath, Object replacement, AbstractXmlParser parser) throws XPathExpressionException, JAXBException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        parser.parseNode(replacement, doc);
        Node newNode = this.getXmlDocument().adoptNode(doc.getFirstChild());
        Node node = (Node)this.evaluate(xPath, XPathConstants.NODE);
        Node parentNode = node.getParentNode();
        parentNode.removeChild(node);
        parentNode.appendChild(newNode);
    }

    public boolean evaluateBoolean(String xPath) throws XPathExpressionException {
        String value = this.evaluateString(xPath);
        return Boolean.parseBoolean(value);
    }

    public void updateAttribute(String xPath, AbstractXJdfType value) throws XPathExpressionException {
        this.updateAttribute(xPath, value.toString());
    }

    public void updateAttribute(String xPath, String value) throws XPathExpressionException {
        String exprString = xPath;
        Attr result = (Attr)this.evaluate(exprString, XPathConstants.NODE);
        result.setValue(value);
    }

    public InputStream getXmlStream() throws TransformerException, IOException {
        ByteArrayInputStream resultStream = new ByteArrayInputStream(this.getXmlBytes());
        return resultStream;
    }

    public byte[] getXmlBytes() throws TransformerException, IOException {
        String line;
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XmlStreamWriter xmlWriter = new XmlStreamWriter((OutputStream)bos, "UTF-8");
        transformer.transform(new DOMSource(this.xmlDocument), new StreamResult((Writer)xmlWriter));
        bos.close();
        byte[] strResult = bos.toByteArray();
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(strResult)));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line.trim());
        }
        byte[] onlyLineResult = sb.toString().getBytes();
        bos = new ByteArrayOutputStream();
        XmlStreamWriter xmlWriter2 = new XmlStreamWriter((OutputStream)bos, "UTF-8");
        transformer.transform(new StreamSource(new ByteArrayInputStream(onlyLineResult)), new StreamResult((Writer)xmlWriter2));
        bos.close();
        String xml = new String(bos.toByteArray());
        StringBuilder b = new StringBuilder(xml);
        if (b.indexOf("--><") != -1) {
            b.insert(b.indexOf("--><") + 3, "\r\n");
        }
        xml = b.toString();
        return xml.getBytes();
    }
}

