/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.partition.PartitionManager;
import org.cip4.lib.xjdf.schema.Audit;
import org.cip4.lib.xjdf.schema.AuditPool;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.XJdfPackager;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlPackager;
import org.cip4.lib.xjdf.xml.internal.PackagerException;
import org.jetbrains.annotations.NotNull;

public class XJdfDocument {
    private final XJDF xjdf;
    private boolean validation = true;

    public XJdfDocument(String jobId, String[] types) {
        this.xjdf = new XJDF();
        this.xjdf.setJobID(jobId);
        this.xjdf.getTypes().addAll(Arrays.asList(types));
    }

    public XJdfDocument(byte[] bytes) throws JAXBException {
        this.xjdf = (XJDF)new XJdfParser().parseStream(new ByteArrayInputStream(bytes));
    }

    public XJdfDocument(XJDF xjdf) {
        this.xjdf = xjdf;
    }

    public XJDF getXJdf() {
        return this.xjdf;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public String toXml() throws JAXBException, IOException {
        return new String(new XJdfParser().parseXJdf(this.xjdf, !this.validation));
    }

    public byte[] getXJdfPackage() throws PackagerException {
        return this.getXJdfPackage(AbstractXmlPackager.CompressionLevel.DEFAULT_COMPRESSION);
    }

    public byte[] getXJdfPackage(AbstractXmlPackager.CompressionLevel compressionLevel) throws PackagerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XJdfPackager xJdfPackager = new XJdfPackager(bos);
        xJdfPackager.setValidation(this.validation);
        xJdfPackager.setCompressionLevel(compressionLevel);
        xJdfPackager.packageXjdf(this.xjdf);
        return bos.toByteArray();
    }

    public void addAudit(Audit audit) {
        if (this.xjdf.getAuditPool() == null) {
            this.xjdf.setAuditPool(new AuditPool());
        }
        this.xjdf.getAuditPool().getAudits().add(audit);
    }

    public ResourceSet addResourceSet(@NotNull SpecificResource specificResource, ResourceSet.Usage usage) {
        String paramName = specificResource.getClass().getSimpleName();
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
        JAXBElement specificResourceJaxB = new JAXBElement(qname, SpecificResource.class, null, (Object)specificResource);
        Resource resource = new Resource();
        resource.setSpecificResource((JAXBElement<? extends SpecificResource>)specificResourceJaxB);
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.getResource().add(resource);
        resourceSet.setName(paramName);
        resourceSet.setUsage(usage);
        this.xjdf.getResourceSet().add(resourceSet);
        return resourceSet;
    }

    public ResourceSet addResourceSet(@NotNull SpecificResource specificResource, ResourceSet.Usage usage, Part part) throws IOException {
        if (part == null) {
            return this.addResourceSet(specificResource, usage);
        }
        HashMap<Part, SpecificResource> map = new HashMap<Part, SpecificResource>();
        map.put(part, specificResource);
        return this.addResourceSet(map, usage);
    }

    public ResourceSet addResourceSet(Map<Part, ? extends SpecificResource> map, ResourceSet.Usage usage) throws IOException {
        if (map.size() == 0) {
            throw new IOException("The resource map requries at leaset one entry.");
        }
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.setUsage(usage);
        for (Part part : map.keySet()) {
            String paramName = map.get(part).getClass().getSimpleName();
            QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
            JAXBElement specificResourceJaxB = new JAXBElement(qname, SpecificResource.class, null, (Object)map.get(part));
            Resource resource = new Resource();
            resource.getPart().add(part);
            resource.setSpecificResource((JAXBElement<? extends SpecificResource>)specificResourceJaxB);
            resourceSet.getResource().add(resource);
            resourceSet.setName(paramName);
        }
        this.xjdf.getResourceSet().add(resourceSet);
        return resourceSet;
    }

    public Resource getResourceByPart(Class<? extends SpecificResource> resourceClazz, Part part) throws IllegalAccessException {
        List<ResourceSet> resourceSets = this.xjdf.getResourceSet();
        Resource result = null;
        for (int i = 0; i < resourceSets.size() && result == null; ++i) {
            ResourceSet resourceSet = resourceSets.get(i);
            if (!resourceClazz.getSimpleName().equals(resourceSet.getName())) continue;
            result = PartitionManager.getResourceByPart(resourceSet, part);
        }
        return result;
    }

    public <T extends SpecificResource> T getSpecificResourceByPart(Class<T> resourceClazz, Part part) throws IllegalAccessException {
        Resource resource = this.getResourceByPart(resourceClazz, part);
        return (T)((SpecificResource)resource.getSpecificResource().getValue());
    }
}

